/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.util.StringUtils;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.runtime.Logger;

public class SimpleLogger
implements Logger {
    private final PrintStream _printStream;

    public SimpleLogger() {
        this._printStream = System.out;
        this._printStream.println("Fallback logger initialized");
    }

    public SimpleLogger(File argFile) throws IOException {
        this._printStream = new PrintStream((OutputStream)new FileOutputStream(argFile, true), true, StandardCharsets.UTF_8.name());
        this._printStream.println("Logger initialized");
    }

    @Override
    public void close() {
        if (this._printStream != null && this._printStream != System.out) {
            this._printStream.flush();
            this._printStream.close();
        }
    }

    @Override
    public void log(Installer installer, Throwable exception) {
        if (installer != null && installer.isVerbose()) {
            this.log(exception);
        }
    }

    @Override
    public void log(String message) {
        if (this._printStream == null) {
            return;
        }
        this.printString(message);
    }

    @Override
    public void log(String argMessage, Throwable argException) {
        this.log(argMessage);
        this.log(argException);
    }

    @Override
    public void log(Throwable exception) {
        if (this._printStream == null) {
            return;
        }
        this.printString(StringUtils.getStackTrace(exception));
    }

    @Override
    public void setLogging(DefaultLogger argLogger) {
        argLogger.setOutputPrintStream(this._printStream);
        argLogger.setErrorPrintStream(this._printStream);
    }

    private void printString(String s) {
        this._printStream.println(s);
        this._printStream.flush();
    }
}

