/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.util.StringTokenizer;

public class VersionHelper {
    public static final String CLAUSE_ALPHA = "alpha";
    public static final String CLAUSE_BETA = "beta";
    public static final String CLAUSE_GAMMA = "gamma";
    public static final String CLAUSE_JAVA_BETA = "ea";

    public boolean equalOrHigher(String test, String version) {
        return this.equalOrHigher(test, version, false);
    }

    public boolean equalOrHigher(String test, String version, boolean javaSyntax) {
        try {
            block4: {
                int versionVer;
                int testVer;
                block5: {
                    String verToken;
                    String testToken;
                    StringTokenizer testSt = new StringTokenizer(test, ".");
                    StringTokenizer verSt = new StringTokenizer(version, ".");
                    do {
                        boolean testMore = testSt.hasMoreTokens();
                        boolean verMore = verSt.hasMoreTokens();
                        if (!testMore || !verMore) break block4;
                        testToken = testSt.nextToken();
                        verToken = verSt.nextToken();
                        testVer = this.getVersion(testToken);
                        if (testVer != (versionVer = this.getVersion(verToken))) break block5;
                    } while (this.equalClause(this.getClause(testToken), this.getClause(verToken)));
                    return this.higherClause(this.getClause(testToken), this.getClause(verToken), javaSyntax);
                }
                return testVer > versionVer;
            }
            if (this.countDots(test) >= this.countDots(version)) {
                return true;
            }
            return test.equals(version);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValid(String version) {
        try {
            StringTokenizer verSt = new StringTokenizer(version, ".");
            boolean verMore = false;
            int i = 0;
            while (verMore = verSt.hasMoreTokens()) {
                short clauseS;
                String verToken = verSt.nextToken();
                if ("".equals(verToken)) {
                    return false;
                }
                this.getVersion(verToken);
                String clause = this.getClause(verToken);
                if (!"".equals(clause) && (clauseS = this.clauseToShort(clause)) != 1 && clauseS != 2 && clauseS != 3) {
                    return false;
                }
                ++i;
            }
            return verMore || i != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean majorVersionCompatible(String test, String version) {
        return this.getMajorVersion(test) == this.getMajorVersion(version);
    }

    private short clauseJavaToShort(String argClause) {
        String clause = argClause;
        if (clause.startsWith("-")) {
            clause = clause.substring(1);
        } else if (CLAUSE_JAVA_BETA.equals(clause)) {
            return -2;
        }
        if (clause.startsWith("_")) {
            int hasDash = clause.indexOf(45);
            if (hasDash > -1) {
                return Short.parseShort(clause.substring(1, hasDash));
            }
            return Short.parseShort(clause.substring(1));
        }
        return 0;
    }

    private short clauseToShort(String argClause) {
        String clause = argClause;
        if (clause.startsWith("-")) {
            clause = clause.substring(1);
        }
        if (CLAUSE_ALPHA.equals(clause)) {
            return 3;
        }
        if (CLAUSE_BETA.equals(clause)) {
            return 2;
        }
        if (CLAUSE_GAMMA.equals(clause)) {
            return 1;
        }
        if (clause.startsWith("_")) {
            int hasDash = clause.indexOf(45);
            if (hasDash > -1) {
                return Short.parseShort(clause.substring(1, hasDash));
            }
            return Short.parseShort(clause.substring(1));
        }
        return Short.MAX_VALUE;
    }

    private short countDots(String fullver) {
        short count = 0;
        for (int i = 0; i < fullver.length(); ++i) {
            if (fullver.charAt(i) != '.') continue;
            count = (short)(count + 1);
        }
        return count;
    }

    private boolean equalClause(String test, String clause) {
        return this.clauseToShort(test) == this.clauseToShort(clause);
    }

    private String getClause(String section) {
        for (int i = 0; i < section.length(); ++i) {
            char c = section.charAt(i);
            if (Character.isDigit(c)) continue;
            return section.substring(i);
        }
        return "";
    }

    private int getMajorVersion(String test) {
        return this.getVersion(test);
    }

    private int getVersion(String section) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < section.length(); ++i) {
            char c = section.charAt(i);
            if (!Character.isDigit(c)) {
                return Integer.parseInt(sb.toString());
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return 0;
    }

    private boolean higherClause(String test, String clause, boolean javaSyntax) {
        if (javaSyntax) {
            return this.clauseJavaToShort(test) > this.clauseJavaToShort(clause);
        }
        return this.clauseToShort(test) > this.clauseToShort(clause);
    }
}

