/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.awt.HeadlessException;
import java.io.IOException;
import java.util.ArrayList;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.plaf.LookAndFeelFactory;
import org.tp23.antinstaller.runtime.AbstractAntRunner;
import org.tp23.antinstaller.runtime.AutoSwingRunner;
import org.tp23.antinstaller.runtime.AutoTextRunner;
import org.tp23.antinstaller.runtime.Runner;
import org.tp23.antinstaller.runtime.SwingRunner;
import org.tp23.antinstaller.runtime.TextRunner;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class CreateUIFilter
implements ExecuteFilter {
    @Override
    public void exec(InstallerContext ctx) throws InstallException {
        try {
            if (ctx.getInstaller().isVerbose()) {
                ctx.log("Creating UI classes");
            }
            ctx.setRunner(this.getRunner(ctx));
            ctx.log("Created UI classes");
        }
        catch (IOException e) {
            throw new InstallException("Unable to create the user interface", e);
        }
        catch (InstallException e) {
            throw new InstallException(e.getMessage(), e);
        }
    }

    private Runner getRunner(InstallerContext ctx) throws IOException, InstallException {
        String overrideUI = ctx.getUIOverride();
        String defaultUI = ctx.getInstaller().getDefaultUi();
        if (overrideUI != null || defaultUI != null) {
            String effectiveType = overrideUI != null ? overrideUI : defaultUI;
            ArrayList<String> allowedTypes = new ArrayList<String>();
            allowedTypes.addAll(ctx.getInstaller().getUi());
            if (allowedTypes.contains("swing")) {
                allowedTypes.add("gui");
            }
            if (overrideUI != null && !allowedTypes.contains(effectiveType)) {
                throw new InstallException("Specified UI override type " + effectiveType + " is not allowed");
            }
            return this.runnerForName(effectiveType, ctx);
        }
        return new AutoTextRunner(ctx);
    }

    private AbstractAntRunner runnerForName(String argName, InstallerContext argContext) {
        String name;
        switch (name = argName.toLowerCase().trim()) {
            case "gui": 
            case "swing": {
                try {
                    new LookAndFeelFactory(argContext).setLAF();
                    return new SwingRunner(argContext);
                }
                catch (HeadlessException ex) {
                    argContext.log("UI type " + argName + " could not be started.  Falling back to text.");
                }
            }
            case "text": {
                return new TextRunner(argContext);
            }
            case "swing-auto": {
                try {
                    new LookAndFeelFactory(argContext).setLAF();
                    return new AutoSwingRunner(argContext);
                }
                catch (HeadlessException ex) {
                    argContext.log("UI type " + argName + " could not be started.  Falling back to text-auto.");
                }
            }
            default: {
                argContext.log("Received unidentified install type of " + argName + ".  Using default of text-auto.");
            }
            case "text-auto": 
        }
        return new AutoTextRunner(argContext);
    }
}

