/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.AppRootInput;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.ConfirmPasswordTextInput;
import org.tp23.antinstaller.input.DateInput;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.input.EvaluatedPropertyInput;
import org.tp23.antinstaller.input.ExtValidatedTextInput;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.input.HiddenPropertyInput;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.input.UnvalidatedTextInput;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.page.SplashPage;
import org.tp23.antinstaller.page.TextPage;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LoadConfigFilter
implements ExecuteFilter {
    private Installer _installer = new Installer();
    private InstallerContext _ctx;

    @Override
    public void exec(InstallerContext argCtx) throws InstallException {
        this._ctx = argCtx;
        try {
            this._installer = this.readConfig(argCtx.getFileRoot(), argCtx.getInstallerConfigFile());
            argCtx.setInstaller(this._installer);
            argCtx.log("Config loaded");
        }
        catch (IOException e) {
            throw new InstallException("Not able to load and read the AntInstaller config", e);
        }
    }

    public InstallerContext getCtx() {
        return this._ctx;
    }

    public Installer getInstaller() {
        return this._installer;
    }

    public Installer readConfig(File fileRoot, String fileName) throws IOException {
        File config = new File(fileRoot, fileName);
        if (!config.exists()) {
            throw new IOException("Could not find file: " + config.getAbsolutePath());
        }
        return this.readConfig(fileRoot, config.toURI());
    }

    protected Installer readConfig(File fileRoot, URI configSource) throws IOException {
        this._installer.getResultContainer().setInstallRoot(fileRoot);
        InputSource xmlInp = new InputSource(configSource.toString());
        this.readConfig(xmlInp);
        return this._installer;
    }

    protected Installer readConfig(InputSource xmlInp) throws IOException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse(xmlInp);
            Element root = doc.getDocumentElement();
            root.normalize();
            this.setProperties(this._installer, root.getAttributes());
            NodeList allPages = root.getElementsByTagName("page");
            this.getPages(this._installer, allPages);
        }
        catch (IOException | ParserConfigurationException | ConfigurationException | SAXException e) {
            throw new IOException("DomFactory error.", e);
        }
        return this._installer;
    }

    protected void setCtx(InstallerContext argCtx) {
        this._ctx = argCtx;
    }

    private List<AbstractInputField> getInnerOutputFields(Element elem) throws ConfigurationException {
        NodeList allFields = elem.getChildNodes();
        ArrayList<AbstractInputField> fields = new ArrayList<AbstractInputField>();
        for (int i = 0; i < allFields.getLength(); ++i) {
            Element fieldElem;
            AbstractInputField field;
            if (!(allFields.item(i) instanceof Element) || (field = this.getOutputFieldType((fieldElem = (Element)allFields.item(i)).getNodeName(), fieldElem)) == null) continue;
            this.setProperties(field, fieldElem.getAttributes());
            fields.add(field);
            field.setResultContainer(this._installer.getResultContainer());
        }
        return fields;
    }

    private void getOutputFields(Page page, Element pageElem) throws ConfigurationException {
        for (AbstractInputField field : this.getInnerOutputFields(pageElem)) {
            page.addOutputField(field);
        }
    }

    private AbstractInputField getOutputFieldType(String type, Element field) throws ConfigurationException {
        if ("text".equalsIgnoreCase(type)) {
            return new UnvalidatedTextInput();
        }
        if ("directory".equalsIgnoreCase(type)) {
            return new DirectoryInput();
        }
        if ("target".equalsIgnoreCase(type)) {
            return new TargetInput();
        }
        if ("file".equalsIgnoreCase(type)) {
            return new FileInput();
        }
        if ("comment".equalsIgnoreCase(type)) {
            return new CommentOutput();
        }
        if ("checkbox".equalsIgnoreCase(type)) {
            return new CheckboxInput();
        }
        if ("validated".equalsIgnoreCase(type)) {
            return new ValidatedTextInput();
        }
        if ("ext-validated".equalsIgnoreCase(type)) {
            return new ExtValidatedTextInput();
        }
        if ("password".equalsIgnoreCase(type)) {
            return new PasswordTextInput();
        }
        if ("password-confirm".equalsIgnoreCase(type)) {
            return new ConfirmPasswordTextInput();
        }
        if ("hidden".equalsIgnoreCase(type)) {
            return new HiddenPropertyInput();
        }
        if ("evaluate".equalsIgnoreCase(type)) {
            return new EvaluatedPropertyInput(this.getCtx());
        }
        if ("date".equalsIgnoreCase(type)) {
            return new DateInput();
        }
        if ("app-root".equalsIgnoreCase(type)) {
            return new AppRootInput();
        }
        if ("conditional".equalsIgnoreCase(type)) {
            ConditionalField conditionalField = new ConditionalField();
            for (AbstractInputField outputField : this.getInnerOutputFields(field)) {
                conditionalField.addField(outputField);
            }
            return conditionalField;
        }
        if ("select".equalsIgnoreCase(type)) {
            SelectInput sInput = new SelectInput();
            NodeList allOptions = field.getElementsByTagName("option");
            for (int i = 0; i < allOptions.getLength(); ++i) {
                Element optionElem = (Element)allOptions.item(i);
                String text = optionElem.getAttribute("text");
                String value = optionElem.getAttribute("value");
                sInput.addOption(text, value);
            }
            return sInput;
        }
        if ("target-select".equalsIgnoreCase(type)) {
            TargetSelectInput sInput = new TargetSelectInput();
            NodeList allOptions = field.getElementsByTagName("option");
            for (int i = 0; i < allOptions.getLength(); ++i) {
                Element optionElem = (Element)allOptions.item(i);
                String text = optionElem.getAttribute("text");
                String value = optionElem.getAttribute("value");
                sInput.addOption(text, value);
            }
            return sInput;
        }
        if ("large-select".equalsIgnoreCase(type)) {
            LargeSelectInput sInput = new LargeSelectInput();
            NodeList allOptions = field.getElementsByTagName("option");
            for (int i = 0; i < allOptions.getLength(); ++i) {
                Element optionElem = (Element)allOptions.item(i);
                String text = optionElem.getAttribute("text");
                String value = optionElem.getAttribute("value");
                sInput.addOption(text, value);
            }
            return sInput;
        }
        throw new ConfigurationException("Unknown Input Field type:" + type);
    }

    private void getPages(Installer installerConfig, NodeList allPages) throws ConfigurationException {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < allPages.getLength(); ++i) {
            Element pageElem = (Element)allPages.item(i);
            Page page = this.getPageType(pageElem.getAttribute("type"));
            this.setProperties(page, pageElem.getAttributes());
            pages.add(page);
            this.getOutputFields(page, pageElem);
        }
        Page[] pageArr = new Page[pages.size()];
        pages.toArray(pageArr);
        installerConfig.setPages(pageArr);
    }

    private Page getPageType(String type) throws ConfigurationException {
        if ("license".equalsIgnoreCase(type)) {
            return new LicensePage();
        }
        if ("input".equalsIgnoreCase(type)) {
            return new SimpleInputPage();
        }
        if ("progress".equalsIgnoreCase(type)) {
            return new ProgressPage();
        }
        if ("splash".equalsIgnoreCase(type)) {
            return new SplashPage();
        }
        if ("text".equalsIgnoreCase(type)) {
            return new TextPage();
        }
        throw new ConfigurationException("Unknown Page type:" + type);
    }

    private void setProperties(Object bean, NamedNodeMap map) {
        int numAtts = map.getLength();
        for (int a = 0; a < numAtts; ++a) {
            Method[] allMethods;
            Node attribute = map.item(a);
            String name = attribute.getNodeName();
            String value = attribute.getNodeValue();
            String methodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            for (Method allMethod : allMethods = bean.getClass().getMethods()) {
                if (!allMethod.getName().equals(methodName)) continue;
                try {
                    Object[] paramValues;
                    Class<?>[] parameters = allMethod.getParameterTypes();
                    if (parameters[0].equals(Boolean.class)) {
                        paramValues = new Boolean[1];
                        paramValues[0] = AbstractInputField.isTrue(value) ? Boolean.TRUE : Boolean.FALSE;
                    } else {
                        paramValues = parameters[0].equals(Integer.class) ? new Integer[]{Integer.valueOf(value)} : new String[]{value};
                    }
                    allMethod.invoke(bean, paramValues);
                }
                catch (IndexOutOfBoundsException ex) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }
}

