/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.runtime.VersionHelper;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.runtime.exe.ExecuteRunnerFilter;

public class PropertyLoaderFilter
implements ExecuteFilter {
    public static final String LOAD = "true";
    public static final String PROMPT = "prompt";
    public static final String PROMPT_AUTO = "prompt-auto";
    public static final String FALSE = "false";
    public static final String DEFAULT_PROPERTIES_FILE_PROPERTY = "antinstaller.properties";
    private final String _fileNameProperty;
    private int _definedPropertiesCount;

    public PropertyLoaderFilter() {
        this(DEFAULT_PROPERTIES_FILE_PROPERTY);
    }

    public PropertyLoaderFilter(String argFileNameProperty) {
        this._fileNameProperty = argFileNameProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void exec(InstallerContext ctx) throws InstallException {
        Installer installer = ctx.getInstaller();
        String loadDefaults = installer.getLoadDefaults();
        if (installer.isVerbose()) {
            ctx.log("loadDefaults attribute:" + loadDefaults);
        }
        boolean load = false;
        if (loadDefaults == null || FALSE.equals(loadDefaults)) {
            if (!installer.isVerbose()) return;
            ctx.log("Not loading defaults");
            return;
        }
        ctx.log("Checking for default properties");
        Properties defaultProps = this.loadDefaultProperties(ctx);
        ctx.log("Checking for predefined properties");
        Properties predefinedProps = this.loadPredefinedProperties(ctx, this._fileNameProperty, defaultProps);
        this._definedPropertiesCount = predefinedProps.size();
        boolean foundProps = false;
        if (this._definedPropertiesCount == 0) {
            ctx.log("No predefined properties");
        } else {
            foundProps = true;
        }
        if (foundProps && PROMPT.equals(loadDefaults)) {
            load = ctx.getMessageRenderer().prompt(ResourceHelper.getResourceString("promptLoadDefaults"));
        } else if (foundProps && PROMPT_AUTO.equals(loadDefaults)) {
            load = ctx.getMessageRenderer().prompt(ResourceHelper.getResourceString("promptLoadDefaults"));
        } else if (foundProps && LOAD.equals(loadDefaults)) {
            load = true;
        }
        if ((!foundProps || !load) && ctx.isAutoBuild() && PROMPT.equals(loadDefaults)) {
            ctx.log("Cant run -auto install without properties");
            throw new ExecuteRunnerFilter.AbortException("Install Aborted: cant load ant.install.properties");
        }
        if (!load) return;
        if (installer.isVerbose()) {
            ctx.log("Loading defaults");
        }
        String propertiesVersion = predefinedProps.getProperty("ant.install.config.version");
        String configVersion = ctx.getInstaller().getVersion();
        if (propertiesVersion == null) throw new ExecuteRunnerFilter.AbortException("Install Aborted: local ant.install.properties missing config version, must be equal or lower than: " + configVersion);
        VersionHelper helper = new VersionHelper();
        if (!propertiesVersion.equals(configVersion) && helper.equalOrHigher(configVersion, propertiesVersion)) {
            if (ctx.isAutoBuild() || !helper.majorVersionCompatible(configVersion, propertiesVersion)) throw new ExecuteRunnerFilter.AbortException("Install Aborted: existing configuration is not compatible, config version: " + configVersion);
            if (!ctx.getMessageRenderer().prompt(ResourceHelper.getResourceString("propertiesVersionMismatch"))) {
                throw new ExecuteRunnerFilter.AbortException("Install Aborted: existing configuration is not compatible, config version: " + configVersion);
            }
        }
        Page[] allPages = installer.getPages();
        this.handleDefaults(ctx, allPages, predefinedProps);
    }

    private Properties loadDefaultProperties(InstallerContext argCtx) {
        Properties ret = new Properties();
        try (InputStream propertiesFileStream = this.getClass().getClassLoader().getResourceAsStream("defaults.properties");){
            if (propertiesFileStream != null) {
                argCtx.log("Found defaults.properties - loading.");
                ret.load(propertiesFileStream);
            } else {
                argCtx.log("Did not find defaults.properties to load.");
            }
        }
        catch (IOException e) {
            argCtx.log("Error", (Throwable)e);
            return new Properties();
        }
        return ret;
    }

    protected boolean isPropertiesLoaded() {
        return this._definedPropertiesCount > 0;
    }

    int getPropertiesFoundCount() {
        return this._definedPropertiesCount;
    }

    private void handleDefaults(InstallerContext ctx, Page[] allPages, Properties props) throws InstallException {
        for (Page allPage : allPages) {
            List<AbstractInputField> fields = allPage.getOutputFields();
            this.setInputValues(ctx, allPage, fields, props);
        }
    }

    private Properties loadPredefinedProperties(InstallerContext context, String fileNamePropertyName, Properties argDefaultProperties) throws InstallException {
        Properties contextProps = InstallerContext.getEnvironment();
        String propertiesFileName = null;
        boolean failSilently = true;
        if (fileNamePropertyName != null) {
            propertiesFileName = contextProps.getProperty("env." + fileNamePropertyName);
            if (propertiesFileName == null) {
                propertiesFileName = contextProps.getProperty("java." + fileNamePropertyName);
            }
            if (propertiesFileName != null) {
                failSilently = false;
            }
        }
        if (propertiesFileName == null) {
            propertiesFileName = "ant.install.properties";
        }
        Properties definedProperties = new Properties();
        argDefaultProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> definedProperties.setProperty(k.toString(), v.toString())));
        if (propertiesFileName != null) {
            File definedPropertiesFile;
            block13: {
                definedPropertiesFile = new File(propertiesFileName);
                context.log("Loading pre-defined properties from file " + definedPropertiesFile.getAbsolutePath());
                try (FileInputStream istream = new FileInputStream(definedPropertiesFile);){
                    definedProperties.load(istream);
                }
                catch (IOException ex) {
                    if (failSilently) break block13;
                    throw new InstallException("Unable to read contents of defined properties file " + definedPropertiesFile.getAbsolutePath(), ex);
                }
            }
            if (context.getInstaller().isDebug()) {
                this.logPropertiesLoaded(context, definedProperties, definedPropertiesFile);
            }
        }
        return definedProperties;
    }

    private void logPropertiesLoaded(InstallerContext context, Properties properties, File propertiesFile) {
        Iterator<Object> iterator = properties.keySet().iterator();
        context.log("Predefined properties (" + this._definedPropertiesCount + ") loaded from " + propertiesFile.getAbsolutePath() + "...");
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            context.log(key + "=" + properties.getProperty(key));
        }
    }

    private void setInputValues(InstallerContext ctx, Page page, List<? extends AbstractInputField> outputFields, Properties props) throws InstallException {
        if (outputFields == null) {
            return;
        }
        String targets = props.getProperty(page.getName() + "-targets");
        List<String> targetsList = this.splitTargets(targets);
        for (AbstractInputField abstractInputField : outputFields) {
            AbstractInputField tgtInput;
            String propName;
            if (abstractInputField instanceof ConditionalField) {
                ConditionalField condField = (ConditionalField)abstractInputField;
                this.setInputValues(ctx, page, condField.getFields(), props);
            }
            if (abstractInputField instanceof CommentOutput || !props.containsKey(propName = abstractInputField.getProperty())) continue;
            String value = props.getProperty(propName);
            if (ctx.getInstaller().isDebug()) {
                ctx.log("Setting " + propName + "=" + value);
            }
            abstractInputField.setDefaultValue(value);
            abstractInputField.setInputResult(value);
            abstractInputField.setEditted(true);
            if (abstractInputField instanceof PasswordTextInput && value == null) {
                ctx.getMessageRenderer().printMessage(ResourceHelper.getResourceString("promptMissingDefaultPassword"));
            }
            if (abstractInputField instanceof TargetInput) {
                tgtInput = (TargetInput)abstractInputField;
                page.removeTarget(((TargetInput)tgtInput).getIdx());
                if (!AbstractInputField.isFalse(value)) {
                    page.addTarget(((TargetInput)tgtInput).getIdx(), ((TargetInput)tgtInput).getTarget());
                    if (!targetsList.contains(((TargetInput)tgtInput).getTarget())) {
                        ctx.log("Defaults error: targets list for page " + page.getName() + " should contain a TargetInput that was true");
                    }
                } else if (AbstractInputField.isTrue(((TargetInput)tgtInput).getForce())) {
                    String msg = "Defaults error: forced target for page " + page.getName() + " has been removed";
                    ctx.log(msg);
                    throw new InstallException(msg);
                }
            }
            if (!(abstractInputField instanceof TargetSelectInput)) continue;
            tgtInput = (TargetSelectInput)abstractInputField;
            page.removeTarget(((TargetSelectInput)tgtInput).getIdx());
            page.addTarget(((TargetSelectInput)tgtInput).getIdx(), value);
        }
        List<String> pageTargets = page.getTargets(ctx);
        for (String targetPerProps : targetsList) {
            if (pageTargets.contains(targetPerProps)) continue;
            ctx.log("Defaults warning: targets list for page " + page.getName() + " should contain " + targetPerProps);
        }
    }

    private List<String> splitTargets(String commaSeparated) {
        if (commaSeparated == null) {
            return Collections.emptyList();
        }
        String[] targets = commaSeparated.split(",");
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = targets[i].trim();
        }
        return Arrays.asList(targets);
    }
}

