/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class DefaultingDirectoryChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    public static final boolean CREATE_MODE = true;
    public static final boolean EXISTING_MODE = false;
    private final boolean _createMode;
    private String _desiredName;

    public DefaultingDirectoryChooser(boolean argCreateMode) {
        this._createMode = argCreateMode;
        if (argCreateMode) {
            this.setFileSelectionMode(2);
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.exists() && f.isDirectory()) {
                        return true;
                    }
                    return !f.exists() && DefaultingDirectoryChooser.this.getFileSystemView().getParentDirectory(f).isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Directories";
                }
            });
            this.addPropertyChangeListener("directoryChanged", t -> {
                File directory = (File)t.getNewValue();
                File currentDirectory = new File(directory, "newfolder");
                if (!this.getCurrentDirectory().equals(currentDirectory)) {
                    this.setCurrentDirectory(currentDirectory);
                }
                File selectedFile = new File(directory, this._desiredName);
                if (this.getSelectedFile() != null && !this.getSelectedFile().equals(selectedFile)) {
                    this.setSelectedFile(selectedFile);
                }
            });
        } else {
            this.setFileSelectionMode(1);
        }
    }

    public void setDefaultDirectory(File dir) {
        if (dir == null) {
            return;
        }
        if (this._createMode) {
            if (this._desiredName == null) {
                this._desiredName = dir.getName();
            }
            File selected = this.determineCreateDir(dir);
            this.setCurrentDirectory(selected.getParentFile());
            this.setSelectedFile(selected);
        } else {
            this.setCurrentDirectory(this.determineExistingDir(dir));
        }
    }

    private File determineCreateDir(File defaultDir) {
        if (defaultDir.exists()) {
            return defaultDir;
        }
        FileSystemView fsv = this.getFileSystemView();
        String dirName = defaultDir.getName();
        File validParent = this.getFSVParent(fsv, defaultDir);
        if (validParent != null) {
            return new File(validParent, dirName);
        }
        return new File(fsv.getHomeDirectory(), dirName);
    }

    private File determineExistingDir(File defaultDir) {
        if (defaultDir.exists()) {
            return defaultDir;
        }
        FileSystemView fsv = this.getFileSystemView();
        File validParent = this.getFSVParent(fsv, defaultDir);
        if (validParent != null) {
            return validParent;
        }
        return fsv.getHomeDirectory();
    }

    private File getFSVParent(FileSystemView fsv, File dir) {
        if (dir == null) {
            return null;
        }
        File parent = dir.getParentFile();
        if (fsv.isRoot(parent) && !parent.exists()) {
            return null;
        }
        if (parent == null || !parent.exists() || !fsv.isFileSystem(parent)) {
            parent = this.getFSVParent(fsv, parent);
        }
        return parent;
    }
}

