/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant.compile;

import com.micros_retail.ant.compile.DuplicateMode;
import com.micros_retail.ant.compile.JarFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;

public class JarCompileHelper {
    public static int compile(Collection<Path> collection, Collection<ResourceCollection> collection2, Path path, Map<String, String> map, Collection<String> collection3, Charset charset, DuplicateMode duplicateMode) throws IOException, URISyntaxException {
        if (Files.exists(path, new LinkOption[0])) {
            throw new BuildException(path + " already exists!");
        }
        URI uRI = new URI("jar:file", null, path.toUri().getPath(), null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        try (FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);){
            Object n3;
            int n;
            block47: {
                Manifest manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0.0");
                if (map != null) {
                    for (Map.Entry object22 : map.entrySet()) {
                        attributes.putValue((String)object22.getKey(), (String)object22.getValue());
                    }
                }
                Path path2 = fileSystem.getPath("META-INF", new String[0]);
                Files.createDirectories(path2, new FileAttribute[0]);
                Path path3 = path2.resolve("MANIFEST.MF");
                try (OutputStream n2 = Files.newOutputStream(path3, new OpenOption[0]);){
                    manifest.write(n2);
                }
                n = 0;
                JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
                if (javaCompiler == null) {
                    throw new IllegalStateException("Could not obtain a JavaCompiler.  Please run with a JDK.");
                }
                n3 = javaCompiler.getStandardFileManager(null, null, charset);
                try (JarFileManager jarFileManager = new JarFileManager(fileSystem, (JavaFileManager)n3, charset);){
                    List<File> list = JarCompileHelper.getSourceFiles(collection);
                    Iterable<? extends JavaFileObject> iterable = n3.getJavaFileObjectsFromFiles(list);
                    if (list.isEmpty()) break block47;
                    JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, jarFileManager, null, collection3, null, iterable);
                    if (compilationTask.call().booleanValue()) {
                        n = list.size();
                        break block47;
                    }
                    throw new BuildException("Compilation errors were encountered.  See output for details.");
                }
                finally {
                    if (n3 != null) {
                        n3.close();
                    }
                }
            }
            if (collection2 != null) {
                n3 = new byte[8192];
                for (ResourceCollection resourceCollection : collection2) {
                    for (Resource resource : resourceCollection) {
                        if (resource.isDirectory()) continue;
                        String string = resource.getName();
                        Path path4 = fileSystem.getPath(string, new String[0]);
                        if (path4.getParent() != null && Files.notExists(path4.getParent(), new LinkOption[0])) {
                            Files.createDirectories(path4.getParent(), new FileAttribute[0]);
                        }
                        ++n;
                        try {
                            OutputStream outputStream = Files.newOutputStream(path4, new OpenOption[0]);
                            try {
                                InputStream inputStream = resource.getInputStream();
                                try {
                                    int n4;
                                    while ((n4 = inputStream.read((byte[])n3)) != -1) {
                                        outputStream.write((byte[])n3, 0, n4);
                                    }
                                }
                                finally {
                                    if (inputStream == null) continue;
                                    inputStream.close();
                                }
                            }
                            finally {
                                if (outputStream == null) continue;
                                outputStream.close();
                            }
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                            if (duplicateMode == DuplicateMode.FAIL) {
                                throw fileAlreadyExistsException;
                            }
                            if (duplicateMode != DuplicateMode.WARN) continue;
                            resource.getProject().log("Ignoring duplicate file: " + resource, fileAlreadyExistsException, 1);
                        }
                    }
                }
            }
            int n5 = n;
            return n5;
        }
    }

    private static List<File> getSourceFiles(Collection<Path> collection) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Path path : collection) {
            List<File> list = JarCompileHelper.getSourceFiles(path);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private static List<File> getSourceFiles(Path path2) throws IOException {
        return Files.walk(path2, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".java")).map(Path::toFile).collect(Collectors.toList());
    }
}

