/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant.filter;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public class SourceHeaderFilter
extends BaseParamFilterReader
implements ChainableReader {
    private static final char[] EOL_CHARS = new char[]{'\r', '\n'};
    private final Pattern REPLACEABLE_COMMENT = Pattern.compile("\\/\\/\\s*(\\$(Id|URL)|Copyright.+?Oracle)");
    private final Pattern PACKAGE_DECLARATION = Pattern.compile("package\\s+");
    private final StringBuilder _currentLineContent = new StringBuilder();
    private boolean _initialized;
    private boolean _commentAdded;
    private String _commentText;
    private String _eol;

    private static String getEol(String string) {
        int n;
        block0: for (int i = n = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            for (char c2 : EOL_CHARS) {
                if (c == c2) continue block0;
            }
            n = i;
            break;
        }
        return string.substring(n + 1);
    }

    public SourceHeaderFilter() {
    }

    public SourceHeaderFilter(Reader reader) {
        super(reader);
    }

    @Override
    public Reader chain(Reader reader) {
        SourceHeaderFilter sourceHeaderFilter = new SourceHeaderFilter(reader);
        sourceHeaderFilter.setCommentText(this._commentText);
        return sourceHeaderFilter;
    }

    @Override
    public int read() throws IOException {
        if (!this._initialized) {
            this.initialize();
        }
        int n = -1;
        if (this._currentLineContent.length() > 0) {
            n = this._currentLineContent.charAt(0);
            this._currentLineContent.deleteCharAt(0);
        } else if (this._commentAdded) {
            n = super.read();
        } else {
            String string = this.readLine();
            if (string != null) {
                this._eol = SourceHeaderFilter.getEol(string);
                this._currentLineContent.append(string);
                String string2 = string.trim();
                if (this.REPLACEABLE_COMMENT.matcher(string2).find()) {
                    this._currentLineContent.setLength(0);
                    this.addCommentToBuffer(this._eol);
                } else if (this.PACKAGE_DECLARATION.matcher(string2).find()) {
                    this._currentLineContent.delete(this._currentLineContent.length() - this._eol.length(), this._currentLineContent.length());
                    this.addCommentToBuffer(this._eol);
                }
                n = this.read();
            } else {
                this.getProject().log("Could not find a replaceable comment or package declaration in the provided resources.  Comment will appear at the end of the file.");
                String string3 = this._eol != null && !this._eol.isEmpty() ? this._eol : String.format("%n", new Object[0]);
                this._currentLineContent.append(string3);
                this.addCommentToBuffer("");
                n = this.read();
            }
        }
        return n;
    }

    public void setCommentText(String string) {
        this._commentText = string;
    }

    private void addCommentToBuffer(String string) {
        this._currentLineContent.append("// ").append(this._commentText).append(string);
        this._commentAdded = true;
    }

    private void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            block6: for (Parameter parameter : parameterArray) {
                switch (parameter.getName()) {
                    case "commentText": {
                        this.setCommentText(parameter.getValue());
                        continue block6;
                    }
                    default: {
                        this.getProject().log("Ignoring unknown parameter: " + parameter.getName());
                    }
                }
            }
        }
        this._initialized = true;
    }
}

