/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant.type;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.AbstractResourceCollectionWrapper;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.ResourceDecorator;

public class FilteredResources
extends AbstractResourceCollectionWrapper {
    private static final AtomicLong IDENTIFIER_GENERATOR = new AtomicLong(0L);
    private final long _identifier = IDENTIFIER_GENERATOR.incrementAndGet();
    private Charset _charset = StandardCharsets.UTF_8;
    private FilterChain _chain;

    public void add(FilterChain filterChain) {
        if (this._chain != null) {
            throw new BuildException("This type accepts 1 FilterChain.");
        }
        this._chain = filterChain;
    }

    @Override
    public boolean isFilesystemOnly() {
        return false;
    }

    public void setCharset(String string) {
        this._charset = Charset.forName(string);
    }

    @Override
    protected Iterator<Resource> createIterator() {
        Iterator<Resource> iterator = this.getResourceCollection().iterator();
        if (iterator instanceof WrapperIterator) {
            WrapperIterator wrapperIterator = (WrapperIterator)iterator;
            if (wrapperIterator._identifier == this._identifier) {
                return iterator;
            }
        }
        return new WrapperIterator(iterator, this._charset, this._chain, this._identifier);
    }

    @Override
    protected int getSize() {
        return this.getResourceCollection().size();
    }

    private static class WrapperResource
    extends ResourceDecorator {
        private final Charset _charset;
        private final FilterChain _chain;
        private SoftReference<byte[]> _effectiveBytes;
        private final long _identifier;

        private WrapperResource(Resource resource, Charset charset, FilterChain filterChain, long l) {
            super(resource);
            this._charset = charset;
            this._chain = filterChain;
            this._identifier = l;
        }

        @Override
        public <T> T as(Class<T> clazz) {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw new BuildException("This ResourceCollection does not support writing.");
        }

        @Override
        public long getSize() {
            try {
                return this.getBytes().length;
            }
            catch (IOException iOException) {
                this.log("Could not successfully determine file bytes.", 1);
                return 0L;
            }
        }

        @Override
        public boolean isFilesystemOnly() {
            return false;
        }

        @Override
        public Iterator<Resource> iterator() {
            Iterator<Resource> iterator = super.iterator();
            return new WrapperIterator(iterator, this._charset, this._chain, this._identifier);
        }

        private byte[] getBytes() throws IOException {
            Object object;
            if (this._effectiveBytes != null && (object = this._effectiveBytes.get()) != null) {
                return object;
            }
            object = new StringBuilder(this.getResource().size());
            try (Object object2 = this.getReader();){
                int n;
                Object object3;
                Reader reader = object2;
                if (this._chain != null) {
                    object3 = this._chain.getFilterReaders().iterator();
                    while (object3.hasNext()) {
                        Object e = object3.next();
                        if (e instanceof ChainableReader) {
                            ChainableReader chainableReader = (ChainableReader)e;
                            reader = chainableReader.chain(reader);
                            continue;
                        }
                        throw new BuildException("Found unknown filter reader of type " + e.getClass());
                    }
                }
                object3 = new char[8192];
                while ((n = reader.read((char[])object3)) != -1) {
                    ((StringBuilder)object).append((char[])object3, 0, n);
                }
            }
            object2 = ((StringBuilder)object).toString().getBytes(this._charset);
            this._effectiveBytes = new SoftReference<Object>(object2);
            return object2;
        }

        private Reader getReader() throws IOException {
            Resource resource = this.getResource();
            if (resource instanceof FileResource) {
                FileResource fileResource = (FileResource)resource;
                File file = fileResource.getFile();
                return Files.newBufferedReader(file.toPath(), this._charset);
            }
            InputStream inputStream = super.getInputStream();
            return new BufferedReader(new InputStreamReader(inputStream, this._charset));
        }
    }

    private static class WrapperIterator
    implements Iterator<Resource> {
        private final Iterator<Resource> _iterator;
        private final Charset _charset;
        private final FilterChain _chain;
        private final long _identifier;

        private WrapperIterator(Iterator<Resource> iterator, Charset charset, FilterChain filterChain, long l) {
            this._iterator = iterator;
            this._charset = charset;
            this._chain = filterChain;
            this._identifier = l;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Resource next() {
            return this.wrapIfNecessary(this._iterator.next());
        }

        private WrapperResource wrapIfNecessary(Resource resource) {
            if (resource instanceof WrapperResource) {
                WrapperResource wrapperResource = (WrapperResource)resource;
                if (wrapperResource._identifier == this._identifier) {
                    return wrapperResource;
                }
            }
            return new WrapperResource(resource, this._charset, this._chain, this._identifier);
        }
    }
}

