/*
 * Decompiled with CFR 0.152.
 */
package dtv.installx.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MergePropertyFiles
extends Task {
    private File origFile_;
    private File mergeFile_;
    private File output_;
    private boolean overwrite_;

    @Override
    public void execute() throws BuildException {
        if (!this.origFile_.exists() && !this.mergeFile_.exists()) {
            throw new BuildException("no xstore.properties file exists. There need to be at least one property file for the installer to proceed.");
        }
        if (!this.origFile_.exists()) {
            this.origFile_ = this.mergeFile_;
            this.mergeFile_ = null;
        } else if (!this.mergeFile_.exists()) {
            this.mergeFile_ = null;
        }
        try {
            String propValue;
            String[] vals;
            Properties baseProps = new Properties();
            FileInputStream baseInput = new FileInputStream(this.origFile_);
            baseProps.load(baseInput);
            baseInput.close();
            if (this.mergeFile_ != null) {
                Properties overrideProps = new Properties();
                FileInputStream overrideInput = new FileInputStream(this.mergeFile_);
                overrideProps.load(overrideInput);
                overrideInput.close();
                overrideProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (baseProps.getProperty(k.toString()) != null) {
                        if (this.overwrite_) {
                            baseProps.setProperty(k.toString(), v.toString());
                        }
                    } else {
                        baseProps.setProperty(k.toString(), v.toString());
                    }
                }));
            }
            ArrayList<String> propNames = new ArrayList<String>();
            if (!this.output_.exists()) {
                this.output_.createNewFile();
            }
            PrintWriter writer = new PrintWriter(new FileWriter(this.output_));
            BufferedReader reader = new BufferedReader(new FileReader(this.origFile_));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    vals = line.split("=");
                    propNames.add(vals[0].trim());
                    propValue = this.escapeValue(baseProps.get(vals[0].trim()).toString());
                    writer.println(vals[0].trim() + "=" + propValue);
                    continue;
                }
                writer.println(line);
            }
            reader.close();
            if (this.mergeFile_ != null) {
                reader = new BufferedReader(new FileReader(this.mergeFile_));
                writer.println();
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || propNames.contains((vals = line.split("="))[0].trim())) continue;
                    propValue = this.escapeValue(baseProps.get(vals[0].trim()).toString());
                    writer.println(vals[0].trim() + "=" + propValue);
                }
                reader.close();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
    }

    public void setMergeFile(File argOverride) {
        this.mergeFile_ = argOverride;
    }

    public void setOrigFile(File argBase) {
        this.origFile_ = argBase;
    }

    public void setOutput(File argOutput) {
        this.output_ = argOutput;
    }

    public void setOverwrite(boolean argOverwrite) {
        this.overwrite_ = argOverwrite;
    }

    private String escapeValue(String argValue) {
        String propValue = argValue;
        propValue = propValue.replace("\\", "\\\\");
        return propValue;
    }
}

