/*
 * Decompiled with CFR 0.152.
 */
package dtv.installx.ant.typedefs;

import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;

public class FileNameWithVersion
extends ResourceComparator {
    private static final String FILE_VERSION_REGEX = ".+?((?:[\\d.]+)+)-((?:[\\d.]+)+).*\\.jar";

    protected String getVersionNumberFromFile(String argFileName) throws IOException {
        Pattern pat = Pattern.compile(FILE_VERSION_REGEX);
        Matcher matcher = pat.matcher(argFileName);
        if (matcher.find()) {
            if (matcher.groupCount() < 2) {
                throw new IOException("File name matched the search pattern, but is not in the correct format (" + argFileName + ")");
            }
            return matcher.group(2);
        }
        throw new IOException("File name is not in the correct versioned format (" + argFileName + ")");
    }

    @Override
    protected int resourceCompare(Resource resource1, Resource resource2) {
        try {
            String versionStr1 = this.getVersionNumberFromFile(resource1.getName());
            String versionStr2 = this.getVersionNumberFromFile(resource2.getName());
            ModuleDescriptor.Version version1 = ModuleDescriptor.Version.parse(versionStr1);
            ModuleDescriptor.Version version2 = ModuleDescriptor.Version.parse(versionStr2);
            this.log("Comparing [" + resource1.getName() + "] to [" + resource2.getName() + "]");
            return version1.compareTo(version2);
        }
        catch (IOException ex) {
            this.log(ex.toString(), 0);
            this.log("Falling back to standard name comparison, this may produce unexpected results.");
            return resource1.getName().compareTo(resource2.getName());
        }
    }
}

