/*
 * Decompiled with CFR 0.152.
 */
package oracle.retail.xstore.installer.resource.impl;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.retail.xstore.installer.resource.IFileResource;
import oracle.retail.xstore.installer.resource.IResource;
import oracle.retail.xstore.installer.resource.IResourceContainer;
import oracle.retail.xstore.installer.resource.impl.Resource;

public class ZipResourceContainer
implements IResourceContainer {
    private final File _file;
    private final ZipInputStream _stream;

    public ZipResourceContainer(File argZipFile) throws IOException {
        this._file = argZipFile;
        this._stream = new ZipInputStream(argZipFile.toURI().toURL().openStream());
    }

    @Override
    public void close() throws IOException {
        this._stream.close();
    }

    @Override
    public File getRoot() {
        return this._file;
    }

    @Override
    public Iterator<IResource> iterator() {
        return new ZipResourceIterator(this._stream);
    }

    private static class ZipResourceIterator
    implements Iterator<IResource> {
        private final ZipInputStream _stream;
        private ZipEntry _currentEntry;

        ZipResourceIterator(ZipInputStream argStream) {
            this._stream = argStream;
        }

        @Override
        public boolean hasNext() {
            if (this._currentEntry == null) {
                try {
                    this._currentEntry = this._stream.getNextEntry();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return this._currentEntry != null;
        }

        @Override
        public IResource next() {
            if (this.hasNext()) {
                String rawPath = this._currentEntry.getName();
                boolean directory = this._currentEntry.isDirectory();
                this._currentEntry = null;
                if (directory) {
                    int end = rawPath.lastIndexOf(47);
                    int start = rawPath.lastIndexOf(47, end - 1) + 1;
                    String folderPath = rawPath.substring(0, end);
                    String folderName = rawPath.substring(start, end);
                    return new Resource(folderPath, folderName);
                }
                int afterLastSlashOrZero = rawPath.lastIndexOf(47) + 1;
                String fileName = rawPath.substring(afterLastSlashOrZero);
                return new ZipFileResource(rawPath, fileName, this._stream);
            }
            throw new NoSuchElementException();
        }
    }

    private static class ZipFileResourceStream
    extends FilterInputStream {
        private final ZipInputStream _stream;

        protected ZipFileResourceStream(ZipInputStream argIn) {
            super(argIn);
            this._stream = argIn;
        }

        @Override
        public void close() throws IOException {
            this._stream.closeEntry();
        }
    }

    private static class ZipFileResource
    extends Resource
    implements IFileResource {
        private final ZipInputStream _stream;

        public ZipFileResource(String argPath, String argName, ZipInputStream argStream) {
            super(argPath, argName);
            this._stream = argStream;
        }

        @Override
        public InputStream getInput() {
            return new ZipFileResourceStream(this._stream);
        }
    }
}

