/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;
import org.tp23.antinstaller.runtime.SimpleLogger;

public class InstallerContext {
    public static final String INSTALLER_CONFIG_FILE = "antinstall-config.xml";
    public static final String LOG_FILE_NAME = "ant.install.log";
    public static final String ENV_PREFIX = "env.";
    public static final String JAVA_PREFIX = "java.";
    private final Logger _logger;
    private Installer _installer = null;
    private MessageRenderer _messageRenderer = null;
    private AntOutputRenderer _antOutputRenderer = null;
    private Runner _runner = null;
    private Page _currentPage = null;
    private File _fileRoot = null;
    private final ChainedListener _buildListener = new ChainedListener();
    private String _uIOverride = null;
    private String _installerConfigFile = "antinstall-config.xml";
    private String _antBuildFile = "build.xml";
    private String _configResource;
    private boolean _installedSucceded = false;

    public static Properties getEnvironment() {
        Properties props = new Properties();
        Map<String, String> osEnv = System.getenv();
        for (Map.Entry<String, String> entry : osEnv.entrySet()) {
            props.put(ENV_PREFIX + entry.getKey(), entry.getValue());
        }
        Properties javaSysProps = System.getProperties();
        for (Map.Entry<Object, Object> property : javaSysProps.entrySet()) {
            props.put(JAVA_PREFIX + property.getKey(), property.getValue());
        }
        return props;
    }

    public static boolean isUnix() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") == -1;
    }

    public InstallerContext() {
        SimpleLogger logger;
        try {
            String defaultName = "./ant.install.log";
            File logFile = new File(defaultName);
            if (logFile.exists() && !logFile.delete()) {
                System.out.println("Warning: Couldn't delete old log file at " + logFile.getAbsolutePath());
            }
            try {
                logFile.createNewFile();
            }
            catch (IOException ex) {
                File tempLogFile = File.createTempFile("ant.install", "log");
                System.out.println("Could not write log file to " + logFile + " falling back to " + tempLogFile);
                logFile = tempLogFile;
            }
            logger = new SimpleLogger(logFile);
        }
        catch (Throwable ex1) {
            System.err.println("Could not initialize file-based logging.  Falling back to console.");
            ex1.printStackTrace();
            logger = new SimpleLogger();
        }
        this._logger = logger;
    }

    public void addBuildListener(BuildListener argBuildListener) {
        if (argBuildListener != null) {
            this._buildListener.addListener(argBuildListener);
        }
    }

    public String getAntBuildFile() {
        return this._antBuildFile;
    }

    public AntOutputRenderer getAntOutputRenderer() {
        return this._antOutputRenderer;
    }

    public ChainedListener getBuildListener() {
        return this._buildListener;
    }

    public String getConfigResource() {
        return this._configResource;
    }

    public Page getCurrentPage() {
        return this._currentPage;
    }

    public File getFileRoot() {
        return this._fileRoot;
    }

    public Installer getInstaller() {
        return this._installer;
    }

    public String getInstallerConfigFile() {
        return this._installerConfigFile;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public MessageRenderer getMessageRenderer() {
        return this._messageRenderer;
    }

    public String getMinJavaVersion() {
        return this._installer.getMinJavaVersion();
    }

    public Runner getRunner() {
        return this._runner;
    }

    public String getUIOverride() {
        return this._uIOverride;
    }

    public boolean isAutoBuild() {
        return this._installer.getDefaultUi().indexOf("-auto") > -1 || this._uIOverride != null && this._uIOverride.indexOf("-auto") > -1;
    }

    public boolean isInstallSucceded() {
        return this._installedSucceded;
    }

    public void log(boolean verbose, Throwable message) {
        if (verbose && this._logger != null) {
            this._logger.log(message);
        }
    }

    public void log(String message) {
        if (this._logger != null) {
            this._logger.log(message);
        }
    }

    public void log(String message, Throwable throwable) {
        if (this._logger != null) {
            this._logger.log(message, throwable);
        }
    }

    public void log(Throwable message) {
        if (this._logger != null) {
            this._logger.log(message);
        }
    }

    public void setAntBuildFile(String argAntBuildFile) {
        this._antBuildFile = argAntBuildFile;
    }

    public void setAntOutputRenderer(AntOutputRenderer argAntOutputRenderer) {
        this._antOutputRenderer = argAntOutputRenderer;
    }

    public void setConfigResource(String argConfigResource) {
        this._configResource = argConfigResource;
    }

    public void setCurrentPage(Page argCurrentPage) {
        this._currentPage = argCurrentPage;
    }

    public void setFileRoot(File argFileRoot) {
        this._fileRoot = argFileRoot;
        try {
            this.log("Ant basedir:" + argFileRoot.getCanonicalPath());
        }
        catch (IOException ex) {
            this.log("Could not canonicalize path " + argFileRoot, (Throwable)ex);
        }
    }

    public void setInstaller(Installer argInstaller) {
        this._installer = argInstaller;
    }

    public void setInstallerConfigFile(String argInstallerConfigFile) {
        this._installerConfigFile = argInstallerConfigFile;
    }

    public void setInstallSucceded(boolean argInstalledSucceded) {
        this._installedSucceded = argInstalledSucceded;
    }

    public void setMessageRenderer(MessageRenderer argMessageRenderer) {
        this._messageRenderer = argMessageRenderer;
    }

    public void setRunner(Runner argRunner) {
        this._runner = argRunner;
    }

    public void setUIOverride(String override) {
        this._uIOverride = override != null ? override.replaceAll("\\s", "").toLowerCase() : null;
    }

    private static class ChainedListener
    implements BuildListener {
        private final Set<BuildListener> _listeners = new HashSet<BuildListener>();

        ChainedListener() {
        }

        @Override
        public void buildFinished(BuildEvent argArg0) {
            for (BuildListener listener : this._listeners) {
                listener.buildFinished(argArg0);
            }
        }

        @Override
        public void buildStarted(BuildEvent argArg0) {
            for (BuildListener listener : this._listeners) {
                listener.buildStarted(argArg0);
            }
        }

        @Override
        public void messageLogged(BuildEvent argArg0) {
            for (BuildListener listener : this._listeners) {
                listener.messageLogged(argArg0);
            }
        }

        @Override
        public void targetFinished(BuildEvent argArg0) {
            for (BuildListener listener : this._listeners) {
                listener.targetFinished(argArg0);
            }
        }

        @Override
        public void targetStarted(BuildEvent argArg0) {
            for (BuildListener listener : this._listeners) {
                listener.targetStarted(argArg0);
            }
        }

        @Override
        public void taskFinished(BuildEvent argArg0) {
            for (BuildListener listener : this._listeners) {
                listener.taskFinished(argArg0);
            }
        }

        @Override
        public void taskStarted(BuildEvent argArg0) {
            for (BuildListener listener : this._listeners) {
                listener.taskStarted(argArg0);
            }
        }

        void addListener(BuildListener argListener) {
            this._listeners.add(argListener);
        }
    }
}

