/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.antmod.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.tp23.antinstaller.InstallerContext;

public final class PropertyTask
extends Task {
    private String _name;
    private String _value;
    private String _resource;

    @Override
    public void execute() throws BuildException {
        if (this._resource != null) {
            this.executeResource();
        } else {
            if (this._name == null || this._value == null) {
                throw new BuildException("either resource or (name and value) can not be null for antinstaller-property task");
            }
            this.executePropVal();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getResource() {
        return this._resource;
    }

    public String getValue() {
        return this._value;
    }

    public void setName(String argName) {
        this._name = argName;
    }

    public void setResource(String argResource) {
        this._resource = argResource;
    }

    public void setValue(String argValue) {
        this._value = argValue;
    }

    private void executePropVal() {
        InstallerContext ctx = (InstallerContext)this.getProject().getReference("antinstaller.internal.context");
        ctx.log("setting property: name=" + this._name + ", value=" + this._value);
        ctx.getInstaller().getResultContainer().setProperty(this._name, this._value);
    }

    private void executeResource() throws BuildException {
        InstallerContext ctx = (InstallerContext)this.getProject().getReference("antinstaller.internal.context");
        try {
            Properties props = new Properties();
            try (InputStream is = this.getClass().getResourceAsStream(this._resource);){
                if (is == null) {
                    ctx.log("Can not find resource: " + this._resource);
                    throw new BuildException("Can not find resource: " + this._resource);
                }
                props.load(is);
            }
            if (ctx.getInstaller().isVerbose()) {
                ctx.log("loaded properties: " + props.size());
            }
            Map<String, String> allProps = ctx.getInstaller().getResultContainer().getAllProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                allProps.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        catch (IOException e) {
            ctx.log("Can not load resource: " + this._resource);
            throw new BuildException("Can not load resource: " + this._resource, e);
        }
    }
}

