/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputException;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.input.Validator;

public class ExtValidatedTextInput
extends ValidatedTextInput {
    private String _validationClass;
    private Validator _validator;
    private Throwable _throwable;

    public Throwable getThrowable() {
        return this._throwable;
    }

    public String getValidationClass() {
        return this._validationClass;
    }

    public Validator getValidator() {
        return this._validator;
    }

    public void setValidationClass(String argValidationClass) {
        this._validationClass = argValidationClass;
        try {
            this._validator = (Validator)Class.forName(argValidationClass).newInstance();
        }
        catch (Exception ex) {
            throw new InputException("Invalid Class in ExtValidated text input", ex);
        }
    }

    @Override
    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    @Override
    public boolean validate(InstallerContext ctx) throws ValidationException {
        String result = this.getInputResult();
        try {
            this._validator.validate(result, ctx);
            this._throwable = null;
            return true;
        }
        catch (ValidationException t) {
            this._throwable = t;
            return false;
        }
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("ExtValidated:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("ExtValidated:property must be set");
            return false;
        }
        if (this.getValidationClass() == null) {
            argOutputHandler.accept("ExtValidated:validationClass must be set");
            return false;
        }
        return true;
    }
}

