/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.function.Consumer;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.Target;
import org.tp23.antinstaller.input.TargetInput;

public class TargetSelectInput
extends SelectInput
implements Target {
    private final int _idx = TargetInput.getGlobalIdx();

    @Override
    public int getIdx() {
        return this._idx;
    }

    @Override
    public String getTarget() {
        return super.getDefaultValue();
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("TargetSelect:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("TargetSelect:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("TargetSelect:defaultValue must be set");
            return false;
        }
        if (this.getOptions().size() < 2) {
            argOutputHandler.accept("TargetSelect:option must have at least two options");
            return false;
        }
        for (int i = 0; i < this.getOptions().size(); ++i) {
            SelectInput.Option o = this.getOptions().get(i);
            if (o.getText() == null) {
                argOutputHandler.accept("TargetSelect:option:text must be set");
                return false;
            }
            if (o.getValue() != null) continue;
            argOutputHandler.accept("TargetSelect:option:value must be set");
            return false;
        }
        boolean defaultExists = false;
        for (int i = 0; i < this.getOptions().size(); ++i) {
            SelectInput.Option o = this.getOptions().get(i);
            if (!o.getValue().equals(this.getDefaultValue())) continue;
            defaultExists = true;
        }
        if (!defaultExists) {
            argOutputHandler.accept("TargetSelect:option:Default must be one of the options");
            return false;
        }
        return true;
    }
}

