/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer;

import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.AbstractSwingPageRenderer;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public final class RendererFactory {
    private static final String RENDERER_SUFFIX = "Renderer";

    public static AbstractSwingPageRenderer getSwingPageRenderer(Page page) throws ClassNotFoundException {
        String fullyQualified = page.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.swing.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append(RENDERER_SUFFIX);
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (AbstractSwingPageRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Class does not meet the contract for SwingPageRenderer:" + rendererClassName, ex);
        }
    }

    public static AbstractSwingOutputFieldRenderer getSwingRenderer(AbstractInputField field) throws ClassNotFoundException {
        String fullyQualified = field.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("OutputField can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("OutputField can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.swing.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append(RENDERER_SUFFIX);
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (AbstractSwingOutputFieldRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Class does not meet the contract for SwingInputFieldRenderer:" + rendererClassName, ex);
        }
    }

    public static AbstractTextPageRenderer getTextPageRenderer(Page page) throws ClassNotFoundException {
        String fullyQualified = page.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.text.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append(RENDERER_SUFFIX);
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (AbstractTextPageRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Class does not meet the contract for TextPageRenderer:" + rendererClassName, ex);
        }
    }

    public static TextOutputFieldRenderer getTextRenderer(AbstractInputField field) throws ClassNotFoundException {
        String fullyQualified = field.getClass().getName();
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException("InputField can not be a member of the default package");
        }
        int prevDot = fullyQualified.substring(0, lastDot - 1).lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            throw new UnsupportedOperationException("InputField can not be a member of a single level package");
        }
        StringBuffer rendererClassName = new StringBuffer();
        rendererClassName.append(fullyQualified.substring(0, prevDot));
        rendererClassName.append(".renderer.text.");
        rendererClassName.append(fullyQualified.substring(lastDot + 1));
        rendererClassName.append(RENDERER_SUFFIX);
        try {
            Class<?> clazz = Class.forName(rendererClassName.toString());
            return (TextOutputFieldRenderer)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Class does not meet the contract for TextInputFieldRenderer:" + rendererClassName, ex);
        }
    }

    private RendererFactory() {
    }
}

