/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;

public class SelectInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private SelectInput _inputField;
    private final ButtonGroup _optionGroup = new ButtonGroup();

    @Override
    public JComponent initComponent(boolean argOverflow) {
        JPanel buttonPanel;
        block5: {
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
            try {
                for (SelectInput.Option option : this._inputField.getOptions()) {
                    JRadioButton jrb = new JRadioButton(option.getText());
                    this._optionGroup.add(jrb);
                    buttonPanel.add(jrb);
                    if (option.getValue().equals(this._inputField.getDefaultValue())) {
                        jrb.setSelected(true);
                    }
                    jrb.addItemListener(e -> this._inputField.setEditted(true));
                }
            }
            catch (Exception e2) {
                this.getInstallerContext().log(e2.getMessage());
                if (!this.getInstallerContext().getInstaller().isVerbose()) break block5;
                this.getInstallerContext().log(e2);
            }
        }
        if (this._inputField.getOptions().size() < 2) {
            throw new IllegalStateException("Expected to find at least 2 options.");
        }
        return this.initDefaultPanel(this._inputField.getDisplayText(), buttonPanel, argOverflow);
    }

    @Override
    public void renderError() {
        this.getInstallerContext().getMessageRenderer().printMessage(ResourceHelper.getResourceString("notValidSelection"));
    }

    @Override
    public void setOutputField(AbstractInputField argInputField) {
        this._inputField = (SelectInput)argInputField;
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            String newDefault = this._inputField.getDefaultValue();
            Enumeration<AbstractButton> enumeration = this._optionGroup.getElements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                if (newDefault.equals(this._inputField.getOptions().get(i).getValue())) {
                    JRadioButton jrb = (JRadioButton)enumeration.nextElement();
                    jrb.setSelected(true);
                } else {
                    enumeration.nextElement();
                }
                ++i;
            }
        }
    }

    @Override
    public void updateInputField() {
        Enumeration<AbstractButton> enumumeration = this._optionGroup.getElements();
        int i = 0;
        while (enumumeration.hasMoreElements()) {
            JRadioButton o = (JRadioButton)enumumeration.nextElement();
            if (o.isSelected()) {
                this._inputField.setValue(this._inputField.getOptions().get(i).getValue());
                break;
            }
            ++i;
        }
        if (i > this._inputField.getOptions().size()) {
            this._inputField.setValue(this._inputField.getDefaultValue());
        }
    }

    protected SelectInput getInputField() {
        return this._inputField;
    }

    protected ButtonGroup getOptionGroup() {
        return this._optionGroup;
    }
}

