/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.util.concurrent.FutureTask;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.MessageRenderer;

public class SwingMessageRenderer
implements MessageRenderer {
    private final InstallerContext _ctx;
    private final JFrame _owner;

    public SwingMessageRenderer(InstallerContext argCtx, JFrame argOwner) {
        this._ctx = argCtx;
        this._owner = argOwner;
    }

    @Override
    public void printMessage(String message) {
        Runnable messageRunnable = () -> JOptionPane.showMessageDialog(this._owner, message, "Message", 1);
        if (SwingUtilities.isEventDispatchThread()) {
            messageRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(messageRunnable);
            }
            catch (Exception e) {
                this._ctx.log(e);
            }
        }
    }

    @Override
    public boolean prompt(String message) {
        FutureTask<Integer> future = new FutureTask<Integer>(() -> JOptionPane.showConfirmDialog(this._owner, message, "Question", 0));
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                future.run();
            } else {
                SwingUtilities.invokeAndWait(future);
            }
            return future.get() == 0;
        }
        catch (Exception e) {
            this._ctx.log(e);
            return false;
        }
    }
}

