/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;

public class Pager {
    private static final int LINES_PER_PAGE = 20;
    private static final int CHARS_PER_LINE = 80;
    private int _stringIndex = 0;
    private final char[] _text;

    public Pager(String argText) {
        this._text = argText.toCharArray();
    }

    public String getText() {
        return new String(this._text);
    }

    public boolean next(Console con) {
        int lineChars = 0;
        int lastSpace = -1;
        char[] lineBuffer = new char[81];
        int lines = 0;
        while (lines < 20) {
            if (this._stringIndex >= this._text.length) {
                return false;
            }
            lineBuffer[lineChars] = this._text[this._stringIndex];
            if (this._text[this._stringIndex] == ' ') {
                lastSpace = lineChars;
            }
            if (this._text[this._stringIndex] == '\n') {
                String tmp = new String(lineBuffer, 0, lineChars + 1);
                con.format(tmp, new Object[0]);
                ++lines;
                lineChars = 0;
                lastSpace = -1;
            } else if (lineChars == 80) {
                if (lastSpace != -1) {
                    con.format(new String(lineBuffer, 0, lastSpace) + "%n", new Object[0]);
                    this._stringIndex -= 80 - lastSpace;
                } else {
                    con.format(new String(lineBuffer, 0, lineChars) + "%n", new Object[0]);
                }
                ++lines;
                lineChars = 0;
                lastSpace = -1;
            } else {
                ++lineChars;
            }
            ++this._stringIndex;
        }
        return true;
    }

    public void rest(Console con) {
        while (this.next(con)) {
        }
    }
}

