/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SplashPage;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;

public class SplashPageRenderer
extends AbstractTextPageRenderer {
    @Override
    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof SplashPage) {
            SplashPage sPage = (SplashPage)page;
            return this.renderSplashPage(sPage);
        }
        throw new InstallException("Wrong Renderer in SplashPageRenderer.renderPage");
    }

    private boolean renderSplashPage(SplashPage page) throws InstallException {
        Console con = System.console();
        if (con != null) {
            this.printHeader(page);
            con.format(page.getAltText(), new Object[0]);
            try {
                con.reader().read();
            }
            catch (IOException ex) {
                throw new InstallException("IOException");
            }
            return true;
        }
        throw new InstallException("Console not available!");
    }
}

