/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.SelectInputRenderer;

public class TargetSelectInputRenderer
extends SelectInputRenderer {
    private InstallerContext _ctx;

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        TargetSelectInput iField = (TargetSelectInput)field;
        this.printText(iField, console);
        String input = console.readLine();
        console.format("%n", new Object[0]);
        if (input == null || "".equals(input)) {
            input = iField.getDefaultValue();
        } else {
            try {
                int idx = Integer.parseInt(input.trim());
                input = iField.getOptions().get(idx - 1).getValue();
            }
            catch (Exception numFormatOrIndexOutOfBounds) {
                return;
            }
        }
        this._ctx.getCurrentPage().removeTarget(iField.getIdx());
        this._ctx.getCurrentPage().addTarget(iField.getIdx(), input);
        iField.setInputResult(input);
    }

    @Override
    public void setContext(InstallerContext argCtx) {
        super.setContext(argCtx);
        this._ctx = argCtx;
    }

    private void printText(TargetSelectInput iField, Console console) {
        console.format("%s%n%s%n", iField.getDisplayText(), ResourceHelper.getResourceString("enterNumber"));
        int sequence = 1;
        for (SelectInput.Option option : iField.getOptions()) {
            String defaultVal = iField.getDefaultValue().equals(option.getValue()) ? " [" + ResourceHelper.getResourceString("_default_") + "]" : "";
            console.format("  %d) %s%s%n", sequence++, option.getText(), defaultVal);
        }
    }
}

