/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.Console;
import java.io.File;
import org.apache.tools.ant.util.StringUtils;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.runtime.SwingRunner;
import org.tp23.antinstaller.runtime.TextRunner;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.runtime.exe.ExecuteRunnerFilter;
import org.tp23.antinstaller.runtime.exe.FilterChain;
import org.tp23.antinstaller.runtime.exe.FilterFactory;
import org.tp23.antinstaller.runtime.exe.FinalizerFilter;

public class ExecInstall {
    public static final String CONFIG_RESOURCE = "/org/tp23/antinstaller/runtime/exe/script.fconfig";
    private final InstallerContext _ctx = new InstallerContext();
    private final FilterChain _chain;

    public static void main(String[] args) {
        int returnCode = 1;
        try {
            FilterChain chain = FilterFactory.factory(CONFIG_RESOURCE);
            ExecInstall installExec = new ExecInstall(chain);
            if (installExec.parseArgs(args, true)) {
                returnCode = installExec.exec();
            }
        }
        catch (InstallException e) {
            System.err.println("Cant load filter chain:/org/tp23/antinstaller/runtime/exe/script.fconfig");
            e.printStackTrace();
        }
        System.exit(returnCode);
    }

    private static void printUsage() {
        Console con = System.console();
        if (con != null) {
            con.format("%s%n", "Usage java -cp $CLASSPATH org.tp23.antinstaller.ExecInstall [text|swing|default] [install root] (-type [buildtype])");
        }
    }

    public ExecInstall(FilterChain argChain) {
        this._chain = argChain;
    }

    public void awaitCompletion() {
        if (this._ctx.getRunner() != null) {
            this._ctx.getRunner().awaitUiCompletion();
        }
    }

    public int exec() {
        ExecuteFilter[] filters = null;
        try {
            this._chain.init(this._ctx);
            filters = this._chain.getFilters();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        for (int i = 0; i < filters.length; ++i) {
            try {
                this._ctx.log("Filter: " + filters[i].getClass().getName());
                filters[i].exec(this._ctx);
                continue;
            }
            catch (ExecuteRunnerFilter.AbortException abort) {
                MessageRenderer vLogger = this._ctx.getMessageRenderer();
                vLogger.printMessage(abort.getMessage());
                this._ctx.log("Aborted");
                FinalizerFilter ff = (FinalizerFilter)filters[filters.length - 1];
                ff.exec(this._ctx);
                return 1;
            }
            catch (Exception ex) {
                MessageRenderer vLogger;
                this._ctx.log("Installation error: " + ex.getMessage() + ": " + ex.getClass().toString());
                boolean verbose = true;
                if (this._ctx.getInstaller() != null) {
                    verbose = this._ctx.getInstaller().isVerbose();
                }
                this._ctx.log(verbose, (Throwable)ex);
                if (this._ctx.getRunner() instanceof TextRunner) {
                    if (verbose) {
                        this._ctx.getAntOutputRenderer().writeErr(StringUtils.getStackTrace(ex));
                    }
                } else if (this._ctx.getRunner() instanceof SwingRunner) {
                    this._ctx.getAntOutputRenderer().writeErr(StringUtils.getStackTrace(ex));
                } else if (verbose) {
                    ex.printStackTrace();
                }
                if ((vLogger = this._ctx.getMessageRenderer()) != null) {
                    vLogger.printMessage(ResourceHelper.getResourceString("installationFailed") + "\n" + ex.getMessage());
                } else {
                    this._ctx.log(ResourceHelper.getResourceString("installationFailed"), (Throwable)ex);
                }
                if (this._ctx.getRunner() != null) {
                    this._ctx.getRunner().fatalError();
                }
                return 1;
            }
        }
        return 0;
    }

    public boolean parseArgs(String[] args, boolean requiresRootDir) {
        String uiOverride = null;
        String installType = null;
        String installRoot = null;
        int i = 0;
        if (args.length > i && !args[i].startsWith("-")) {
            uiOverride = args[i];
            ++i;
            this._ctx.setUIOverride(uiOverride);
        }
        if (requiresRootDir) {
            if (args.length > i && !args[i].startsWith("-")) {
                installRoot = args[i];
                ++i;
                this._ctx.setFileRoot(new File(installRoot));
            } else {
                ExecInstall.printUsage();
                return false;
            }
        }
        while (i < args.length) {
            if ("-type".equals(args[i]) && args.length > i + 1) {
                installType = args[i + 1];
                ++i;
                String configFileName = "antinstall-config-" + installType + ".xml";
                String buildFileName = "build-" + installType + ".xml";
                this._ctx.setInstallerConfigFile(configFileName);
                this._ctx.setAntBuildFile(buildFileName);
            }
            ++i;
        }
        return true;
    }

    public void setInstallRoot(File installRoot) {
        this._ctx.setFileRoot(installRoot);
    }
}

