/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.tp23.gui.widget.SelectFileAction;

public class FollowingJTextArea
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private boolean _follow = true;

    public FollowingJTextArea() {
        final JPopupMenu popUp = this.getPopupMenu();
        this.add(popUp);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    popUp.show(FollowingJTextArea.this, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void append(String str) {
        super.append(str);
        if (this._follow) {
            this.scrollToEnd();
        }
    }

    public boolean isFollow() {
        return this._follow;
    }

    public void setFollow(boolean argFollow) {
        this._follow = argFollow;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu contextMenu = new JPopupMenu("Options");
        JMenuItem saveMenu = new JMenuItem("Save Text");
        saveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block7: {
                    SelectFileAction action = new SelectFileAction("Save Output", null, null);
                    try {
                        action.actionPerformed(new ActionEvent(this, 0, "Save Output"));
                        if (action.getSelectedFile() == null) break block7;
                        try (OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(action.getSelectedFile()), StandardCharsets.UTF_8);){
                            fos.write(FollowingJTextArea.this.getText());
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "Could not save output due to an IO Exception.");
                    }
                }
            }
        });
        contextMenu.add(saveMenu);
        JMenuItem toggleFollowMenu = new JMenuItem("Toggle Follow");
        toggleFollowMenu.addActionListener(t -> this.toggleFollow());
        contextMenu.add(toggleFollowMenu);
        JMenuItem jumpToEndMenu = new JMenuItem("Jump To End");
        jumpToEndMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FollowingJTextArea.this.setCaretPosition(FollowingJTextArea.this.getDocument().getLength());
            }
        });
        contextMenu.add(toggleFollowMenu);
        JMenuItem clearTextMenu = new JMenuItem("Clear Text");
        clearTextMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FollowingJTextArea.this.setText("");
            }
        });
        contextMenu.add(clearTextMenu);
        return contextMenu;
    }

    private void scrollToEnd() {
        this.setCaretPosition(this.getDocument().getLength());
    }

    private void toggleFollow() {
        this.setFollow(!this.isFollow());
    }
}

