/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class MethodValueToProperty
extends Task {
    private String _className;
    private String _methodName;
    private String _propertyName;
    private boolean isStatic = true;
    private Path _classPath;

    @Override
    public void execute() {
        if (this._className == null || this._methodName == null || this._propertyName == null || this._classPath == null) {
            throw new BuildException("Classpath, class name, method name, and property name must be provided.");
        }
        AntClassLoader antClassLoader = this.getProject().createClassLoader(this._classPath);
        try {
            Class<?> clazz = antClassLoader.findClass(this._className);
            Method method = clazz.getMethod(this._methodName, new Class[0]);
            Object var4_6 = null;
            if (!this.isStatic) {
                var4_6 = clazz.newInstance();
            }
            Object object = method.invoke(var4_6, new Object[0]);
            this.getProject().setProperty(this._propertyName, String.valueOf(object));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException("An error occurred when invoking the method.", exception);
        }
        finally {
            antClassLoader.cleanup();
            if (antClassLoader instanceof Closeable) {
                AntClassLoader antClassLoader2 = antClassLoader;
                try {
                    antClassLoader2.close();
                }
                catch (IOException iOException) {
                    this.log("Could not close classloader.", iOException, 1);
                }
            }
        }
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public void setClasspathRef(Reference reference) {
        this._classPath = new Path(this.getProject());
        this._classPath.setRefid(reference);
    }

    public void setIsStatic(Boolean bl) {
        this.isStatic = bl;
    }

    public void setMethodName(String string) {
        this._methodName = string;
    }

    public void setPropertyName(String string) {
        this._propertyName = string;
    }
}

