/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class RecursiveSearch
extends Task {
    private final Map<String, ArchiveFileType> _mappings = new HashMap<String, ArchiveFileType>();
    private final List<ResourceCollection> _searchRoots = new ArrayList<ResourceCollection>();
    private final List<ArchiveMapping> _customMappings = new ArrayList<ArchiveMapping>();
    private final List<AbstractSearch> _searches = new ArrayList<AbstractSearch>();
    private final List<String> _matches = new ArrayList<String>();
    private final ZipScanner _zipScanner = new ZipScanner();
    private final TarScanner _tarScanner = new TarScanner();
    private final TarGzScanner _tarGzScanner = new TarGzScanner();
    private final TarBzScanner _tarBzScanner = new TarBzScanner();
    private boolean _failIfFound = true;
    private Pattern _ignorePattern;
    private String[] _extensions;
    private long _scannedFiles = 0L;
    private long _scannedArchives = 0L;

    static String convertPath(Stack<String> stack) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stack) {
            stringBuilder.append(RecursiveSearch.normalizePath(string));
            stringBuilder.append(File.separatorChar);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    static String getFileName(String string) {
        String string2 = RecursiveSearch.normalizePath(string);
        int n = string2.lastIndexOf(File.separatorChar);
        if (n != -1) {
            return string2.substring(n + 1);
        }
        return string2;
    }

    static String normalizePath(String string) {
        if (File.separatorChar != '/' && string.indexOf(47) != -1) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    static InputStream wrapForNoClose(InputStream inputStream) {
        return new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public RecursiveSearch() {
        this._mappings.put("zip", ArchiveFileType.ZIP);
        this._mappings.put("jar", ArchiveFileType.ZIP);
        this._mappings.put("war", ArchiveFileType.ZIP);
        this._mappings.put("ear", ArchiveFileType.ZIP);
        this._mappings.put("apk", ArchiveFileType.ZIP);
        this._mappings.put("ipa", ArchiveFileType.ZIP);
        this._mappings.put("xcarchive", ArchiveFileType.ZIP);
        this._mappings.put("tar", ArchiveFileType.TAR);
        this._mappings.put("tar.gz", ArchiveFileType.TARGZ);
        this._mappings.put("tgz", ArchiveFileType.TARGZ);
        this._mappings.put("tar.bz2", ArchiveFileType.TARBZ);
    }

    public void add(ResourceCollection resourceCollection) {
        this._searchRoots.add(resourceCollection);
    }

    public ArchiveMapping createArchiveMapping() {
        ArchiveMapping archiveMapping = new ArchiveMapping();
        this._customMappings.add(archiveMapping);
        return archiveMapping;
    }

    public SearchPattern createSearchPattern() {
        SearchPattern searchPattern = new SearchPattern();
        this._searches.add(searchPattern);
        return searchPattern;
    }

    public SearchString createSearchString() {
        SearchString searchString = new SearchString();
        this._searches.add(searchString);
        return searchString;
    }

    @Override
    public void execute() {
        for (ArchiveMapping object : this._customMappings) {
            if (object._extension != null && object._archiveType != null) {
                this._mappings.put(object._extension, object._archiveType);
                continue;
            }
            throw new BuildException("The extension and archiveType attributes must be provided on archivemapping elements.");
        }
        this._extensions = this._mappings.keySet().toArray(new String[this._mappings.size()]);
        Stack stack = new Stack();
        for (ResourceCollection resourceCollection : this._searchRoots) {
            try {
                this.traverseResources(stack, resourceCollection);
            }
            catch (IOException iOException) {
                throw new BuildException("Could not process resource: " + resourceCollection, iOException);
            }
        }
        this.log("Processed " + this._scannedFiles + " files, including " + this._scannedArchives + " archives.");
        if (this._failIfFound && !this._matches.isEmpty()) {
            throw new BuildException("Expected not to find:\n" + this._searches.stream().map(Object::toString).collect(Collectors.joining("\n")) + "\nBut found:\n" + this._matches.stream().collect(Collectors.joining("\n")));
        }
        if (!this._failIfFound && this._matches.isEmpty()) {
            throw new BuildException("Expected to find at least one:\n" + this._searches.stream().map(Object::toString).collect(Collectors.joining("\n")) + "\nBut did not find it.");
        }
    }

    public void setFailIfFound(boolean bl) {
        this._failIfFound = bl;
    }

    public void setIgnoreNames(String string) {
        String[] stringArray = string.split("\\s*,\\s*");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (string2.indexOf(42) != -1 || string2.indexOf(63) != -1) {
                String string3 = string2;
                string3 = string2.replace(".", "\\.");
                string3 = string2.replace("*", ".*");
                string3 = string3.replace("?", ".");
                arrayList.add(string3);
                continue;
            }
            arrayList.add(Pattern.quote(string2));
        }
        String string4 = arrayList.stream().collect(Collectors.joining("|", "(", ")"));
        this._ignorePattern = Pattern.compile(string4);
    }

    void processEntry(Stack<String> stack, Supplier<InputStream> supplier, boolean bl) throws IOException {
        String string = RecursiveSearch.getFileName(stack.peek());
        if (this._ignorePattern != null && this._ignorePattern.matcher(string).matches()) {
            return;
        }
        this.checkMatch(stack, string);
        IContentScanner iContentScanner = this.getScanner(string);
        if (iContentScanner != null) {
            try (InputStream inputStream = bl ? supplier.get() : RecursiveSearch.wrapForNoClose(supplier.get());){
                iContentScanner.scan(inputStream, stack);
            }
            ++this._scannedArchives;
        }
        ++this._scannedFiles;
    }

    private void checkMatch(Stack<String> stack, String string) {
        for (AbstractSearch abstractSearch : this._searches) {
            if (!abstractSearch.matches(string)) continue;
            this._matches.add(RecursiveSearch.convertPath(stack));
        }
    }

    private IContentScanner getScanner(String string) {
        for (String string2 : this._extensions) {
            if (!string.endsWith(string2) || string.charAt(string.length() - string2.length() - 1) != '.') continue;
            ArchiveFileType archiveFileType = this._mappings.get(string2);
            if (archiveFileType == ArchiveFileType.ZIP) {
                return this._zipScanner;
            }
            if (archiveFileType == ArchiveFileType.TAR) {
                return this._tarScanner;
            }
            if (archiveFileType == ArchiveFileType.TARBZ) {
                return this._tarBzScanner;
            }
            if (archiveFileType == ArchiveFileType.TARGZ) {
                return this._tarGzScanner;
            }
            this.log("Cannot find scanner for: " + archiveFileType, 1);
        }
        return null;
    }

    private void traverseResources(Stack<String> stack, ResourceCollection resourceCollection) throws IOException {
        for (Resource resource : resourceCollection) {
            stack.push(resource.toString());
            this.processEntry(stack, () -> {
                try {
                    return resource.getInputStream();
                }
                catch (IOException iOException) {
                    throw new BuildException(iOException);
                }
            }, true);
            stack.pop();
        }
    }

    private static enum ArchiveFileType {
        ZIP,
        TAR,
        TARGZ,
        TARBZ;

    }

    class ZipScanner
    extends AbstractArchiveScanner {
        ZipScanner() {
        }

        @Override
        protected void scanImpl(InputStream inputStream, Stack<String> stack) throws IOException {
            try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    stack.push(zipEntry.getName());
                    RecursiveSearch.this.processEntry(stack, () -> zipInputStream, false);
                    stack.pop();
                }
            }
        }
    }

    class TarScanner
    extends AbstractArchiveScanner {
        TarScanner() {
        }

        @Override
        protected void scanImpl(InputStream inputStream, Stack<String> stack) throws IOException {
            try (TarInputStream tarInputStream = new TarInputStream(inputStream);){
                TarEntry tarEntry = null;
                while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                    if (tarEntry.isDirectory()) continue;
                    stack.push(tarEntry.getName());
                    RecursiveSearch.this.processEntry(stack, () -> tarInputStream, false);
                    stack.pop();
                }
            }
        }
    }

    class TarGzScanner
    extends TarScanner {
        TarGzScanner() {
        }

        @Override
        public void scan(InputStream inputStream, Stack<String> stack) throws IOException {
            try (GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);){
                super.scan(gZIPInputStream, stack);
            }
        }
    }

    class TarBzScanner
    extends TarScanner {
        TarBzScanner() {
        }

        @Override
        public void scan(InputStream inputStream, Stack<String> stack) throws IOException {
            if (inputStream.read() != 66 || inputStream.read() != 90) {
                throw new BuildException("Invalid bz2 file: " + RecursiveSearch.convertPath(stack));
            }
            try (CBZip2InputStream cBZip2InputStream = new CBZip2InputStream(inputStream);){
                super.scan(cBZip2InputStream, stack);
            }
        }
    }

    static interface IContentScanner {
        public void scan(InputStream var1, Stack<String> var2) throws IOException;
    }

    static abstract class AbstractSearch {
        AbstractSearch() {
        }

        abstract boolean matches(String var1);
    }

    abstract class AbstractArchiveScanner
    implements IContentScanner {
        AbstractArchiveScanner() {
        }

        @Override
        public void scan(InputStream inputStream, Stack<String> stack) throws IOException {
            String string = RecursiveSearch.convertPath(stack);
            RecursiveSearch.this.log("Scanning file " + string, 4);
            try {
                this.scanImpl(inputStream, stack);
            }
            catch (IOException iOException) {
                RecursiveSearch.this.log("Could not read " + RecursiveSearch.convertPath(stack) + " - " + iOException.getMessage());
            }
        }

        protected abstract void scanImpl(InputStream var1, Stack<String> var2) throws IOException;
    }

    public static class SearchString
    extends AbstractSearch {
        private String _name;

        public void setName(String string) {
            this._name = string;
        }

        public String toString() {
            return "Name[" + this._name + "]";
        }

        @Override
        boolean matches(String string) {
            return this._name.equals(string);
        }
    }

    public static class SearchPattern
    extends AbstractSearch {
        private Pattern _pattern;

        public void setPattern(String string) {
            this._pattern = Pattern.compile(string);
        }

        public String toString() {
            return "Pattern[" + this._pattern + "]";
        }

        @Override
        boolean matches(String string) {
            return this._pattern.matcher(string).matches();
        }
    }

    public static class ArchiveMapping {
        String _extension;
        ArchiveFileType _archiveType;

        public void setArchiveType(String string) {
            try {
                ArchiveFileType archiveFileType;
                this._archiveType = archiveFileType = ArchiveFileType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BuildException("Could not parse archiveType of " + string + ".  Supported types are: " + Arrays.toString((Object[])ArchiveFileType.values()), illegalArgumentException);
            }
        }

        public void setExtension(String string) {
            String string2 = string.trim();
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            this._extension = string2;
        }
    }
}

