/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.PropertiesFileRenderer;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.EvaluatedPropertyInput;
import org.tp23.antinstaller.input.SecretPropertyField;
import org.tp23.antinstaller.page.Page;

public class ExplicitPropertiesFileRenderer
implements PropertiesFileRenderer {
    private static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final char[] HEXIDECIMALS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void renderProperties(InstallerContext ctx, File baseDir) {
        block9: {
            Installer installer = ctx.getInstaller();
            Page[] completedPages = installer.getPages();
            try {
                File antInstallProperties = new File(baseDir.getAbsolutePath(), "ant.install.properties");
                try (BufferedWriter propertiesData = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(antInstallProperties), CHARSET));){
                    propertiesData.append("### Ant Installer - properties auto generated on ");
                    propertiesData.append(this.convert(new Date().toString(), true));
                    propertiesData.append(NEW_LINE);
                    propertiesData.append(NEW_LINE);
                    propertiesData.append("basedir");
                    propertiesData.append(" = ");
                    propertiesData.append(this.convert(baseDir.getAbsolutePath(), true));
                    propertiesData.append(NEW_LINE);
                    propertiesData.append("ant.install.config.version");
                    propertiesData.append(" = ");
                    propertiesData.append(this.convert(ctx.getInstaller().getVersion(), true));
                    propertiesData.append(NEW_LINE);
                    propertiesData.append(NEW_LINE);
                    for (Page completedPage : completedPages) {
                        List<AbstractInputField> fields = completedPage.getOutputFields();
                        propertiesData.append(NEW_LINE);
                        propertiesData.append("## Properties from Page:").append(completedPage.getName());
                        propertiesData.append(NEW_LINE);
                        this.retrievePropertiesData(fields, propertiesData);
                        List<String> targets = completedPage.getTargets(ctx);
                        if (targets.isEmpty()) continue;
                        Iterator<String> iterator = targets.iterator();
                        StringBuffer targetProperty = new StringBuffer();
                        while (iterator.hasNext()) {
                            String target = iterator.next();
                            targetProperty.append(target).append(",");
                        }
                        propertiesData.append("# Targets selected for page");
                        propertiesData.append(NEW_LINE);
                        String property = this.convert(completedPage.getName() + "-targets", true);
                        String value = this.convert(targetProperty.toString(), true);
                        propertiesData.append(property).append(" = ").append(value);
                        propertiesData.append(NEW_LINE);
                    }
                }
            }
            catch (Throwable ex) {
                if (!ctx.getInstaller().isVerbose()) break block9;
                ctx.log(ex);
            }
        }
    }

    private String convert(String input, boolean doSpaces) {
        if (input == null) {
            return "";
        }
        int num = input.length();
        StringBuffer sb = new StringBuffer(num);
        block12: for (int i = 0; i < num; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || doSpaces) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block12;
                }
                case '=': {
                    sb.append("\\=");
                    continue block12;
                }
                case ':': {
                    sb.append("\\:");
                    continue block12;
                }
                case '#': {
                    sb.append("\\#");
                    continue block12;
                }
                case '!': {
                    sb.append("\\!");
                    continue block12;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append("\\u").append(this.hex(c >> 12 & 0xF)).append(this.hex(c >> 8 & 0xF)).append(this.hex(c >> 4 & 0xF)).append(this.hex(c & 0xF));
                        continue block12;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private char hex(int val) {
        return HEXIDECIMALS[val & 0xF];
    }

    private void retrievePropertiesData(List<AbstractInputField> fields, Appendable propertiesData) throws IOException {
        String property = null;
        String value = null;
        for (AbstractInputField field2 : fields) {
            if (field2 instanceof SecretPropertyField) {
                AbstractInputField field = field2;
                propertiesData.append("# Property hidden ").append(field2.getClass().getSimpleName());
                propertiesData.append(' ').append(field2.getDisplayText());
                propertiesData.append(NEW_LINE);
                property = this.convert(field.getProperty(), true);
                propertiesData.append("#").append(property).append("=XXXXXXXX");
                propertiesData.append(NEW_LINE);
                continue;
            }
            if (field2 instanceof ConditionalField) {
                ConditionalField confField = (ConditionalField)field2;
                this.retrievePropertiesData(confField.getFields(), propertiesData);
                continue;
            }
            if (field2 instanceof CommentOutput || field2 instanceof EvaluatedPropertyInput) continue;
            String result = field2.getInputResult();
            propertiesData.append("# ").append(field2.getClass().getSimpleName());
            propertiesData.append(' ').append(field2.getDisplayText());
            propertiesData.append(NEW_LINE);
            property = this.convert(field2.getProperty(), true);
            value = this.convert(result, false);
            propertiesData.append(property).append(" = ").append(value);
            propertiesData.append(NEW_LINE);
        }
    }
}

