/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.antmod;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectHelper3
extends ProjectHelper {
    protected final FileUtils _fileUtils = FileUtils.getFileUtils();
    protected final AntHandler _elementHandler = new ElementHandler();
    protected final AntHandler _targetHandler = new TargetHandler();
    protected final AntHandler _mainHandler = new MainHandler();
    protected final AntHandler _projectHandler = new ProjectHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(Project project, Object source) throws BuildException {
        this.getImportStack().addElement(source);
        AntXMLContext context = null;
        context = (AntXMLContext)project.getReference("ant.parsing.context");
        if (context == null) {
            context = new AntXMLContext(project);
            project.addReference("ant.parsing.context", context);
            project.addReference("ant.targets", context.getTargets());
        }
        if (this.getImportStack().size() > 1) {
            context.setIgnoreProjectTag(true);
            Target currentTarget = context.getCurrentTarget();
            try {
                Target newCurrent = new Target();
                newCurrent.setProject(project);
                newCurrent.setName("");
                context.setCurrentTarget(newCurrent);
                this.parse(project, source, new RootHandler(context, this._mainHandler));
                newCurrent.execute();
            }
            finally {
                context.setCurrentTarget(currentTarget);
            }
        } else {
            this.parse(project, source, new RootHandler(context, this._mainHandler));
            context.getImplicitTarget().execute();
        }
    }

    public void parse(Project project, Object source, RootHandler handler) throws BuildException {
        AntXMLContext context = handler.getContext();
        try {
            Serializable buildFile;
            String uri = null;
            if (source instanceof File) {
                buildFile = (File)source;
                context.setBuildFile((File)buildFile);
                uri = ((File)buildFile).toURI().toString();
            } else if (source instanceof URL) {
                buildFile = (URL)source;
                context.setBuildFile((URL)buildFile);
                uri = ((URL)buildFile).toURI().toString();
            } else {
                throw new BuildException("Source " + source.getClass().getName() + " not supported by this plugin");
            }
            XMLReader parser = JAXPUtils.getNamespaceXMLReader();
            InputSource inputSource = new InputSource(uri);
            project.log("parsing buildfile with URI: " + uri, 3);
            RootHandler hb = handler;
            parser.setContentHandler(hb);
            parser.setEntityResolver(hb);
            parser.setErrorHandler(hb);
            parser.setDTDHandler(hb);
            parser.parse(inputSource);
        }
        catch (SAXParseException exc) {
            Location location = new Location(exc.getSystemId(), exc.getLineNumber(), exc.getColumnNumber());
            Exception t = exc.getException();
            if (t instanceof BuildException) {
                BuildException be = (BuildException)t;
                if (be.getLocation() == Location.UNKNOWN_LOCATION) {
                    be.setLocation(location);
                }
                throw be;
            }
            throw new BuildException(exc.getMessage(), t, location);
        }
        catch (SAXException exc) {
            Exception t = exc.getException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(exc.getMessage(), t);
        }
        catch (FileNotFoundException | URISyntaxException exc) {
            throw new BuildException(exc);
        }
        catch (UnsupportedEncodingException exc) {
            throw new BuildException("Encoding of project file " + source.toString() + " is invalid.", exc);
        }
        catch (IOException exc) {
            throw new BuildException("Error reading project file " + source.toString() + ": " + exc.getMessage(), exc);
        }
    }

    public UnknownElement parseUnknownElement(Project project, URL source) throws BuildException {
        Target dummyTarget = new Target();
        dummyTarget.setProject(project);
        AntXMLContext context = new AntXMLContext(project);
        context.addTarget(dummyTarget);
        context.setImplicitTarget(dummyTarget);
        this.parse(context.getProject(), source, new RootHandler(context, this._elementHandler));
        Task[] tasks = dummyTarget.getTasks();
        if (tasks.length != 1) {
            throw new BuildException("No tasks defined");
        }
        return (UnknownElement)tasks[0];
    }

    public class TargetHandler
    extends AntHandler {
        @Override
        public void onEndElement(String uri, String tag, AntXMLContext context) {
            context.setCurrentTarget(context.getImplicitTarget());
        }

        @Override
        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            return ProjectHelper3.this._elementHandler;
        }

        @Override
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            Object name = null;
            String depends = "";
            Project project = context.getProject();
            Target target = new Target();
            target.setProject(project);
            context.addTarget(target);
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrUri = attrs.getURI(i);
                if (attrUri != null && !"".equals(attrUri) && !attrUri.equals(uri)) continue;
                String key = attrs.getLocalName(i);
                String value = attrs.getValue(i);
                if ("name".equals(key)) {
                    name = value;
                    if (!"".equals(name)) continue;
                    throw new BuildException("name attribute must not be empty");
                }
                if ("depends".equals(key)) {
                    depends = value;
                    continue;
                }
                if ("if".equals(key)) {
                    target.setIf(value);
                    continue;
                }
                if ("unless".equals(key)) {
                    target.setUnless(value);
                    continue;
                }
                if ("id".equals(key)) {
                    if (value == null || "".equals(value)) continue;
                    context.getProject().addReference(value, target);
                    continue;
                }
                if ("description".equals(key)) {
                    target.setDescription(value);
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + key + "\"", context.getLocator());
            }
            if (name == null) {
                throw new SAXParseException("target element appears without a name attribute", context.getLocator());
            }
            Hashtable<String, Target> currentTargets = project.getTargets();
            if (currentTargets.containsKey(name)) {
                if (!context.isIgnoringProjectTag()) {
                    throw new BuildException("Duplicate target '" + name + "'", new Location(context.getLocator().getSystemId(), context.getLocator().getLineNumber(), context.getLocator().getColumnNumber()));
                }
                if (context.getCurrentProjectName() != null) {
                    String newName = context.getCurrentProjectName() + "." + name;
                    project.log("Already defined in main or a previous import, define " + (String)name + " as " + newName, 3);
                    name = newName;
                } else {
                    project.log("Already defined in main or a previous import, ignore " + name, 3);
                    name = null;
                }
            }
            if (name != null) {
                target.setName((String)name);
                project.addOrReplaceTarget((String)name, target);
            }
            if (depends.length() > 0) {
                target.setDepends(depends);
            }
        }
    }

    public class RootHandler
    extends DefaultHandler {
        private final Stack<AntHandler> _antHandlers = new Stack();
        private final AntXMLContext _context;
        private AntHandler _currentHandler = null;

        public RootHandler(AntXMLContext argContext, AntHandler rootHandler) {
            this._currentHandler = rootHandler;
            this._antHandlers.push(this._currentHandler);
            this._context = argContext;
        }

        @Override
        public void characters(char[] buf, int start, int count) throws SAXParseException {
            this._currentHandler.characters(buf, start, count, this._context);
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            AntHandler prev;
            this._currentHandler.onEndElement(uri, name, this._context);
            this._currentHandler = prev = this._antHandlers.pop();
            if (this._currentHandler != null) {
                this._currentHandler.onEndChild(uri, name, qName, this._context);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) {
            this._context.endPrefixMapping(prefix);
        }

        public AntHandler getCurrentAntHandler() {
            return this._currentHandler;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            this._context.getProject().log("resolving systemId: " + systemId, 3);
            if (systemId.startsWith("file:")) {
                String path = ProjectHelper3.this._fileUtils.fromURI(systemId);
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = ProjectHelper3.this._fileUtils.resolveFile(this._context.getBuildFileParent(), path);
                }
                return new InputSource(file.toURI().toString());
            }
            return null;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this._context.setLocator(locator);
        }

        @Override
        public void startElement(String uri, String tag, String qname, Attributes attrs) throws SAXParseException {
            AntHandler next = this._currentHandler.onStartChild(uri, tag, qname, attrs, this._context);
            this._antHandlers.push(this._currentHandler);
            this._currentHandler = next;
            this._currentHandler.onStartElement(uri, tag, qname, attrs, this._context);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this._context.startPrefixMapping(prefix, uri);
        }

        protected AntXMLContext getContext() {
            return this._context;
        }
    }

    public class ProjectHandler
    extends AntHandler {
        @Override
        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            if ("target".equals(name) && ("".equals(uri) || uri.equals("antlib:org.apache.tools.ant"))) {
                return ProjectHelper3.this._targetHandler;
            }
            return ProjectHelper3.this._elementHandler;
        }

        @Override
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            String baseDir = null;
            boolean nameAttributeSet = false;
            Project project = context.getProject();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrUri = attrs.getURI(i);
                if (attrUri != null && !"".equals(attrUri) && !attrUri.equals(uri)) continue;
                String key = attrs.getLocalName(i);
                String value = attrs.getValue(i);
                if ("default".equals(key)) {
                    if (value == null || "".equals(value) || context.isIgnoringProjectTag()) continue;
                    project.setDefault(value);
                    continue;
                }
                if ("name".equals(key)) {
                    if (value == null) continue;
                    context.setCurrentProjectName(value);
                    nameAttributeSet = true;
                    if (context.isIgnoringProjectTag()) continue;
                    project.setName(value);
                    project.addReference(value, project);
                    continue;
                }
                if ("id".equals(key)) {
                    if (value == null || context.isIgnoringProjectTag()) continue;
                    project.addReference(value, project);
                    continue;
                }
                if ("basedir".equals(key)) {
                    if (context.isIgnoringProjectTag()) continue;
                    baseDir = value;
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + attrs.getQName(i) + "\"", context.getLocator());
            }
            String antFileProp = "ant.file." + context.getCurrentProjectName();
            String dup = project.getProperty(antFileProp);
            if (dup != null && nameAttributeSet) {
                File dupFile = new File(dup);
                if (context.isIgnoringProjectTag() && !dupFile.equals(context.getBuildFile())) {
                    project.log("Duplicated project name in import. Project " + context.getCurrentProjectName() + " defined first in " + dup + " and again in " + context.getBuildFile(), 1);
                }
            }
            if (context.getBuildFile() != null) {
                project.setUserProperty("ant.file." + context.getCurrentProjectName(), context.getBuildFile().toString());
            }
            if (context.isIgnoringProjectTag()) {
                return;
            }
            if (project.getProperty("basedir") != null) {
                project.setBasedir(project.getProperty("basedir"));
            } else if (baseDir == null) {
                project.setBasedir(context.getBuildFileParent().getAbsolutePath());
            } else if (new File(baseDir).isAbsolute()) {
                project.setBasedir(baseDir);
            } else {
                project.setBaseDir(ProjectHelper3.this._fileUtils.resolveFile(context.getBuildFileParent(), baseDir));
            }
            project.addTarget("", context.getImplicitTarget());
            context.setCurrentTarget(context.getImplicitTarget());
        }
    }

    public class MainHandler
    extends AntHandler {
        @Override
        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            if ("project".equals(name) && ("".equals(uri) || "antlib:org.apache.tools.ant".equals(uri))) {
                return ProjectHelper3.this._projectHandler;
            }
            throw new SAXParseException("Unexpected element \"" + qname + "\" " + name, context.getLocator());
        }
    }

    public class ElementHandler
    extends AntHandler {
        @Override
        public void characters(char[] buf, int start, int count, AntXMLContext context) throws SAXParseException {
            RuntimeConfigurable wrapper = context.currentWrapper();
            wrapper.addText(buf, start, count);
        }

        @Override
        public void onEndElement(String uri, String tag, AntXMLContext context) {
            context.popWrapper();
        }

        @Override
        public AntHandler onStartChild(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            return ProjectHelper3.this._elementHandler;
        }

        @Override
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            RuntimeConfigurable parentWrapper = context.currentWrapper();
            Object parent = null;
            if (parentWrapper != null) {
                parent = parentWrapper.getProxy();
            }
            UnknownElement task = new UnknownElement(tag);
            task.setProject(context.getProject());
            task.setNamespace(uri);
            task.setQName(qname);
            task.setTaskType(ProjectHelper.genComponentName(task.getNamespace(), tag));
            task.setTaskName(qname);
            Location location = new Location(context.getLocator().getSystemId(), context.getLocator().getLineNumber(), context.getLocator().getColumnNumber());
            task.setLocation(location);
            task.setOwningTarget(context.getCurrentTarget());
            context.configureId(task, attrs);
            if (parent != null) {
                ((UnknownElement)parent).addChild(task);
            } else {
                context.getCurrentTarget().addTask(task);
            }
            RuntimeConfigurable wrapper = new RuntimeConfigurable(task, task.getTaskName());
            for (int i = 0; i < attrs.getLength(); ++i) {
                Object name = attrs.getLocalName(i);
                String attrUri = attrs.getURI(i);
                if (attrUri != null && !"".equals(attrUri) && !attrUri.equals(uri)) {
                    name = attrUri + ":" + attrs.getQName(i);
                }
                String value = attrs.getValue(i);
                if ("ant-type".equals(name) || "antlib:org.apache.tools.ant".equals(attrUri) && "ant-type".equals(attrs.getLocalName(i))) {
                    name = "ant-type";
                    int index = value.indexOf(":");
                    if (index != -1) {
                        String prefix = value.substring(0, index);
                        String mappedUri = context.getPrefixMapping(prefix);
                        if (mappedUri == null) {
                            throw new BuildException("Unable to find XML NS prefix " + prefix);
                        }
                        value = ProjectHelper.genComponentName(mappedUri, value.substring(index + 1));
                    }
                }
                wrapper.setAttribute((String)name, value);
            }
            if (parentWrapper != null) {
                parentWrapper.addChild(wrapper);
            }
            context.pushWrapper(wrapper);
        }
    }

    public class AntHandler {
        public void characters(char[] buf, int start, int count, AntXMLContext context) throws SAXParseException {
            String s = new String(buf, start, count).trim();
            if (s.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + s + "\"", context.getLocator());
            }
        }

        public void onEndChild(String uri, String tag, String qname, AntXMLContext context) throws SAXParseException {
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
        }

        public AntHandler onStartChild(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + qname + " \"", context.getLocator());
        }

        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
        }

        protected void checkNamespace(String uri) {
        }
    }
}

