/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;

public class HiddenPropertyInput
extends AbstractInputField {
    private static final String TYPE_NAME = "hidden";

    public void setValue(String propValue) {
        this.setDefaultValue(propValue);
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        return true;
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getProperty() == null) {
            argOutputHandler.accept("hidden: property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("hidden: value must be set");
            return false;
        }
        return true;
    }
}

