/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;

public class LargeSelectInput
extends AbstractInputField {
    private int _optionIndex = 0;
    private final List<Option> _options = new ArrayList<Option>();

    public void addOption(String argText, String argValue) {
        Option newOption = new Option(++this._optionIndex, argText, argValue);
        this._options.add(newOption);
    }

    public List<Option> getOptions() {
        return Collections.unmodifiableList(this._options);
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        String value = this.getInputResult();
        boolean ok = false;
        for (Option option : this._options) {
            ok |= option.getValue().equals(value);
        }
        return ok;
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("LargeSelect:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("LargeSelect:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("LargeSelect:defaultValue must be set");
            return false;
        }
        if (this.getOptions().size() < 2) {
            argOutputHandler.accept("LargeSelect:option must have at least two options");
            return false;
        }
        for (int i = 0; i < this.getOptions().size(); ++i) {
            Option o = this.getOptions().get(i);
            if (o.getText() == null) {
                argOutputHandler.accept("LargeSelect:option:text must be set");
                return false;
            }
            if (o.getValue() != null) continue;
            argOutputHandler.accept("LargeSelect:option:value must be set");
            return false;
        }
        boolean defaultExists = false;
        for (int i = 0; i < this.getOptions().size(); ++i) {
            Option o = this.getOptions().get(i);
            if (!o.getValue().equals(this.getDefaultValue())) continue;
            defaultExists = true;
        }
        if (!defaultExists) {
            argOutputHandler.accept("LargeSelect:option:Default must be one of the options");
            return false;
        }
        return true;
    }

    public class Option {
        private final int _index;
        private final String _text;
        private final String _value;

        Option(int argIndex, String argText, String argValue) {
            this._index = argIndex;
            this._text = argText;
            this._value = argValue;
        }

        public String getText() {
            return LargeSelectInput.this.getTranslatedOrDefault(LargeSelectInput.this.getProperty() + "." + this._index + ".displayText", this._text);
        }

        public String getValue() {
            return this._value;
        }
    }
}

