/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;

public class CheckboxInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private CheckboxInput _inputField;
    private final JCheckBox _checkBox = new JCheckBox();

    @Override
    public JComponent initComponent(boolean argOverflow) {
        JPanel panel = this.initDefaultPanel(this._inputField.getDisplayText(), this._checkBox, argOverflow);
        this._checkBox.setSelected(AbstractInputField.isTrue(this._inputField.getDefaultValue()));
        this._checkBox.setEnabled(!AbstractInputField.isTrue(this._inputField.getForce()));
        this._checkBox.addActionListener(e -> {
            this.updateInputField();
            this._inputField.setEditted(true);
        });
        return panel;
    }

    @Override
    public void setOutputField(AbstractInputField argInputField) {
        this._inputField = (CheckboxInput)argInputField;
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            String newDefault = this._inputField.getDefaultValue();
            this._checkBox.setSelected(AbstractInputField.isTrue(newDefault));
        }
    }

    @Override
    public void updateInputField() {
        boolean selected = this._checkBox.isSelected();
        if (selected) {
            this._inputField.setValue("true");
        } else {
            this._inputField.setValue("false");
        }
    }
}

