/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.SizeHelper;
import org.tp23.gui.widget.DefaultingDirectoryChooser;

public class DirectoryInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private static final String EMPTY_STRING = "";
    private DirectoryInput _inputField;
    private boolean _createMode;
    private DefaultingDirectoryChooser _chooser = null;
    private final JTextField _jTextField = new JTextField();
    private final JButton _browseButton = new JButton();
    private final JPanel _browsePanel = new JPanel();

    @Override
    public JComponent initComponent(boolean argOverflow) {
        this._browsePanel.setLayout(new BorderLayout());
        this._browsePanel.add((Component)this._jTextField, "Center");
        this._browsePanel.add((Component)this._browseButton, "East");
        this._browseButton.setPreferredSize(new Dimension(90, SizeHelper.getFieldHeight()));
        JPanel panel = this.initDefaultPanel(this._inputField.getDisplayText(), this._browsePanel, argOverflow);
        this._browseButton.addActionListener(e -> {
            String dirPath;
            File selectedFile = null;
            if (this._chooser == null) {
                this._chooser = new DefaultingDirectoryChooser(this._createMode);
                this._chooser.setFileHidingEnabled(false);
            }
            if ((dirPath = this._jTextField.getText()) == null) {
                dirPath = EMPTY_STRING;
            }
            if ((dirPath = dirPath.trim()).length() == 0) {
                dirPath = this._inputField.getDefaultValue(true);
                this._jTextField.setText(dirPath);
            }
            this._chooser.setDefaultDirectory(new File(dirPath));
            int returnVal = this._chooser.showDialog(panel.getParent(), e.getActionCommand());
            if (returnVal == 0) {
                selectedFile = this._chooser.getSelectedFile();
            }
            if (selectedFile != null) {
                this._jTextField.setText(selectedFile.getAbsolutePath());
                this._inputField.setValue(selectedFile.getAbsolutePath());
                this._inputField.setEditted(true);
            }
        });
        this._browseButton.setText(ResourceHelper.getResourceString("selectFolder"));
        this._jTextField.setText(this._inputField.getDefaultValue(true));
        this._jTextField.addActionListener(e -> this.updateInputField());
        return panel;
    }

    @Override
    public void renderError() {
        this._jTextField.requestFocus();
    }

    @Override
    public void setOutputField(AbstractInputField argInputField) {
        this._inputField = (DirectoryInput)argInputField;
        this._inputField.setValue(this._inputField.getDefaultValue(true));
        this._createMode = AbstractInputField.isTrue(this._inputField.getCreate());
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            this._jTextField.setText(this._inputField.getDefaultValue(true));
        }
    }

    @Override
    public void updateInputField() {
        if (!this._inputField.getDefaultValue(true).equals(this._jTextField.getText())) {
            this._inputField.setEditted(true);
        }
        this._inputField.setValue(this._jTextField.getText());
    }
}

