/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.Pager;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class LicensePageRenderer
extends AbstractTextPageRenderer {
    private static final String NEXT_CHAR = ResourceHelper.getResourceString("nextChar");
    private boolean _usePaging = false;

    @Override
    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof LicensePage) {
            LicensePage lPage = (LicensePage)page;
            String strUsePaging = lPage.getUsePaging();
            this._usePaging = strUsePaging != null && this.isTrue(strUsePaging);
            return this.renderLicensePage(lPage);
        }
        throw new InstallException("Wrong Renderer in LicensePageRenderer.renderPage");
    }

    private String getNextInstructions() {
        return ResourceHelper.getResourceString("license_next");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renderLicensePage(LicensePage page) throws InstallException {
        try {
            this.getConsole().format("%n", new Object[0]);
            this.getConsole().readLine("%s: ", ResourceHelper.getResourceString("clickViewLicense"));
            String resource = page.getResource();
            InputStream licensein = this.getClass().getResourceAsStream(resource);
            if (licensein == null) {
                throw new ConfigurationException("License resource '" + resource + "' is missing from installer");
            }
            StringBuffer sb = new StringBuffer();
            try (BufferedReader licenseReader = new BufferedReader(new InputStreamReader(licensein, StandardCharsets.UTF_8));){
                this.printHeader(page);
                String lineread = null;
                while ((lineread = licenseReader.readLine()) != null) {
                    sb.append(lineread);
                    sb.append('\n');
                }
            }
            finally {
                licensein.close();
            }
            String command = null;
            Pager pager = new Pager(sb.toString());
            if (this._usePaging) {
                while (pager.next(this.getConsole())) {
                    this.getConsole().format("%n", new Object[0]);
                    command = this.getConsole().readLine(this.getNextInstructions(), new Object[0]);
                    if (command.toUpperCase().startsWith(NEXT_CHAR)) continue;
                }
                pager.rest(this.getConsole());
            } else {
                this.getConsole().format(pager.getText() + "%n", new Object[0]);
            }
            for (int i = 0; i < 80; ++i) {
                this.getConsole().format("~", new Object[0]);
            }
            this.getConsole().format("%n", new Object[0]);
            command = this.getConsole().readLine("%s: ", ResourceHelper.getResourceString("licenseAccept"));
            command = command.trim();
            if (this.isTrue(command)) {
                return true;
            }
            page.setAbort(true);
            return false;
        }
        catch (IOException ex) {
            throw new InstallException("Not able to read license file", ex);
        }
    }
}

