/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.ConsoleOutputRenderer;
import org.tp23.antinstaller.runtime.AbstractAntRunner;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.Runner;

public class AutoTextRunner
extends AbstractAntRunner
implements Runner {
    private final InstallerContext _ctx;
    private final IfPropertyHelper _ifHelper;
    private final AntOutputRenderer _outputRenderer;

    public AutoTextRunner(InstallerContext argCtx) {
        super(argCtx);
        this._ctx = argCtx;
        this._ifHelper = new IfPropertyHelper(argCtx);
        this._outputRenderer = new ConsoleOutputRenderer();
        argCtx.setAntOutputRenderer(this._outputRenderer);
        argCtx.setMessageRenderer(new MessageRenderer(){

            @Override
            public void printMessage(String argMessage) {
                AutoTextRunner.this.printOutput(argMessage);
            }

            @Override
            public boolean prompt(String argMessage) {
                return false;
            }
        });
    }

    @Override
    public void antFinished() {
        this.printOutput(ResourceHelper.getResourceString("finished"));
    }

    @Override
    public void awaitUiCompletion() {
    }

    @Override
    public void fatalError() {
        this.printOutput(ResourceHelper.getResourceString("failed"));
    }

    @Override
    public boolean runInstaller() throws InstallException {
        Page[] pages;
        Installer installer = this._ctx.getInstaller();
        for (Page page : pages = installer.getPages()) {
            if (page.getPostDisplayTarget() == null || !this._ifHelper.ifProperty(page) || !this._ifHelper.ifTarget(page, installer.getPages())) continue;
            this.runPost(page);
        }
        return true;
    }

    public String toString() {
        return "TextAutoRunner";
    }

    protected void printError(String argMessage) {
        this._outputRenderer.writeErr(argMessage);
    }

    protected void printOutput(String argMessage) {
        this._outputRenderer.writeOut(argMessage);
    }
}

