/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.VersionHelper;
import org.tp23.antinstaller.runtime.exe.LoadConfigFilter;
import org.tp23.antinstaller.runtime.logic.ExpressionBuilder;

public class ConfigurationLoader
extends LoadConfigFilter {
    private final Consumer<String> _logConsumer;

    public ConfigurationLoader(Consumer<String> argLogConsumer) {
        this._logConsumer = argLogConsumer;
    }

    public int validate() {
        Page[] pages = this.getInstaller().getPages();
        boolean foundErrors = false;
        HashSet<String> pageNames = new HashSet<String>();
        HashSet<String> targets = new HashSet<String>();
        HashSet<String> propertyNames = new HashSet<String>();
        if (this.validateInstallerAttributes()) {
            foundErrors = true;
        }
        for (Page page : pages) {
            SimpleInputPage sPage;
            if (pageNames.contains(page.getName())) {
                this._logConsumer.accept("Error: page name '" + page.getName() + "' repeated - auto loading of configuration will fail");
                foundErrors = true;
            }
            pageNames.add(page.getName());
            if (page instanceof SimpleInputPage && (sPage = (SimpleInputPage)page).getIfProperty() != null) {
                try {
                    ResultContainer mock = new ResultContainer();
                    ExpressionBuilder.parseLogicalExpressions(mock, sPage.getIfProperty());
                }
                catch (ConfigurationException configExc) {
                    this._logConsumer.accept("Error: loading ifProperty," + sPage.getIfProperty() + ", page: " + page.getName() + ", message: " + configExc.getMessage());
                    foundErrors = true;
                }
            }
            HashSet<String> pagePropertyNames = new HashSet<String>();
            List<AbstractInputField> fields = page.getOutputFields();
            for (int f = 0; f < fields.size(); ++f) {
                String propertyName;
                AbstractInputField inputField = fields.get(f);
                if (!inputField.validateObject(this._logConsumer)) {
                    foundErrors = true;
                    this._logConsumer.accept("Error in page:" + page.getName());
                }
                if (inputField instanceof TargetInput) {
                    TargetInput tgtInput = (TargetInput)inputField;
                    targets.add(tgtInput.getTarget());
                }
                if (inputField instanceof ConditionalField || inputField instanceof CommentOutput) continue;
                AbstractInputField genericInput = inputField;
                if (genericInput.getProperty().endsWith("-targets")) {
                    this._logConsumer.accept("Error: invalid property name:" + genericInput.getProperty());
                    this._logConsumer.accept("InputField names must not end with -targets");
                }
                if (propertyNames.contains(propertyName = genericInput.getProperty())) {
                    this._logConsumer.accept("Repeated property name:" + propertyName);
                    this._logConsumer.accept("Loading defaults from file will probably not work:" + propertyName);
                } else {
                    propertyNames.add(propertyName);
                }
                if (pagePropertyNames.contains(propertyName)) {
                    foundErrors = true;
                    System.out.println("Repeated property name: page=" + page.getName() + ", property=" + propertyName);
                    continue;
                }
                pagePropertyNames.add(propertyName);
            }
        }
        if (!(pages[pages.length - 1] instanceof ProgressPage)) {
            foundErrors = true;
            this._logConsumer.accept("Last Page should be a progress page");
        } else if (pages[pages.length - 1].getPostDisplayTarget() != null) {
            foundErrors = true;
            this._logConsumer.accept("Progress pages do not support postDisplayTarget");
        }
        int numOfPageTargets = 0;
        for (Page page : pages) {
            numOfPageTargets += page.getAllTargets().size();
        }
        if (numOfPageTargets == 0) {
            this._logConsumer.accept("Warning: No Page Targets (not a problem if there are target input types)");
        }
        for (String tgt : targets) {
            if (!tgt.endsWith("-targets")) continue;
            this._logConsumer.accept("Error: invalid target name:" + tgt);
            this._logConsumer.accept("Target names must not end with -targets");
            foundErrors = true;
        }
        int numOfTargetInputs = 0;
        ArrayList<String> targetsSoFar = new ArrayList<String>();
        for (Page page : pages) {
            SimpleInputPage simple;
            String ifTarget;
            if (page instanceof SimpleInputPage && (ifTarget = (simple = (SimpleInputPage)page).getIfTarget()) != null && !targetsSoFar.contains(ifTarget)) {
                this._logConsumer.accept("ifTarget=" + ifTarget);
                this._logConsumer.accept("ifTarget will never test true, no prior target in page:" + page.getName());
            }
            targetsSoFar.addAll(page.getAllTargets());
            List<AbstractInputField> fields = page.getOutputFields();
            for (AbstractInputField field : fields) {
                AbstractInputField ti;
                if (field instanceof TargetInput) {
                    if (numOfTargetInputs == 0) {
                        this._logConsumer.accept("Found target input type");
                    }
                    ++numOfTargetInputs;
                    ti = (TargetInput)field;
                    targetsSoFar.add(((TargetInput)ti).getTarget());
                }
                if (!(field instanceof TargetSelectInput)) continue;
                if (numOfTargetInputs == 0) {
                    this._logConsumer.accept("Found target input type");
                }
                ++numOfTargetInputs;
                ti = (TargetSelectInput)field;
                List<SelectInput.Option> options = ((SelectInput)ti).getOptions();
                for (SelectInput.Option option : options) {
                    targetsSoFar.add(option.getValue());
                }
            }
        }
        if (numOfPageTargets == 0 && numOfTargetInputs == 0) {
            this._logConsumer.accept("Warning: No targets found, installer may do nothing.");
        }
        if (!foundErrors) {
            return 0;
        }
        return 1;
    }

    private boolean validateInstallerAttributes() {
        boolean foundErrors = false;
        String[] validLAFValues = new String[]{"greymetal", "native"};
        if (this.validateValue("lookAndFeel", this.getInstaller().getLookAndFeel(), true, validLAFValues)) {
            this._logConsumer.accept("Warning: non standard LookAndFeel ensure the correct classes are on the classpath at runtime:" + this.getInstaller().getLookAndFeel());
        }
        if (this.getInstaller().getName() == null) {
            this._logConsumer.accept("Error: installer element attribute does not exist: name");
            foundErrors = true;
        }
        try {
            String high = this.getInstaller().getHigh();
            if (high != null) {
                this.getInstaller().parseHighValue(high);
            }
        }
        catch (Exception e) {
            this._logConsumer.accept("Error: installer element attribute incorrect format (e.g. 400:20): high");
            foundErrors = true;
        }
        try {
            String wide = this.getInstaller().getWide();
            if (wide != null) {
                this.getInstaller().parseWideValue(wide);
            }
        }
        catch (Exception e) {
            this._logConsumer.accept("Error: installer element attribute incorrect format (e.g. 600:275): wide");
            foundErrors = true;
        }
        String[] validLoadDefaultValues = new String[]{"false", "true", "prompt", "prompt-auto"};
        boolean loadDefaultsNull = true;
        if (this.getInstaller().supportsAutoBuild()) {
            loadDefaultsNull = false;
        }
        foundErrors |= this.validateValue("loadDefaults", this.getInstaller().getLoadDefaults(), loadDefaultsNull, validLoadDefaultValues);
        VersionHelper vHelper = new VersionHelper();
        if (this.getInstaller().supportsAutoBuild() && !vHelper.isValid(this.getInstaller().getVersion())) {
            System.out.println("Error: invalid version attribute, required for -auto builds:" + this.getInstaller().getVersion());
            foundErrors = true;
        }
        if (this.getInstaller().getVersion() != null && !vHelper.isValid(this.getInstaller().getVersion())) {
            this._logConsumer.accept("Error: invalid version attribute format examples 1.2.0 , 0.2beta:" + this.getInstaller().getVersion());
            foundErrors = true;
        }
        return foundErrors;
    }

    private boolean validateValue(String att, String value, boolean allowsNull, String[] validValues) {
        if (value == null) {
            if (!allowsNull) {
                this._logConsumer.accept("Error: installer element attribute does not exist: " + att);
                return true;
            }
            return false;
        }
        for (String validValue : validValues) {
            if (!validValue.equals(value)) continue;
            return false;
        }
        this._logConsumer.accept("Error: installer element attribute not valid value: " + att);
        return true;
    }
}

