/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.antmod.FeedbackListener;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingPageRenderer;
import org.tp23.antinstaller.renderer.swing.PageCompletionListener;
import org.tp23.antinstaller.renderer.swing.SizeHelper;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;
import org.tp23.antinstaller.renderer.swing.SwingMessageRenderer;
import org.tp23.antinstaller.runtime.AbstractAntRunner;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;

public class SwingRunner
extends AbstractAntRunner
implements Runner,
PageCompletionListener {
    private final CountDownLatch _uiCloseLatch = new CountDownLatch(1);
    private final CountDownLatch _uiCompleteLatch = new CountDownLatch(1);
    private final AtomicBoolean _doAnt = new AtomicBoolean(false);
    private final JFrame _frame;
    private final SwingInstallerContext _swingCtx;
    private final IfPropertyHelper _ifHelper;
    private final InstallerContext _ctx;
    private final Logger _logger;
    private final Installer _installer;
    private AbstractSwingPageRenderer _currentPage;

    public SwingRunner(InstallerContext argCtx) {
        super(argCtx);
        this._ifHelper = new IfPropertyHelper(argCtx);
        this._logger = argCtx.getLogger();
        this._installer = argCtx.getInstaller();
        this._ctx = argCtx;
        FutureTask<JFrame> task = new FutureTask<JFrame>(() -> {
            JFrame frame = new JFrame();
            frame.setTitle(this._installer.getName());
            frame.setDefaultCloseOperation(2);
            frame.setSize(SizeHelper.getPageWidth(), SizeHelper.getPageHeight());
            frame.getRootPane().setDoubleBuffered(true);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent argE) {
                    SwingRunner.this.abort();
                    super.windowClosing(argE);
                }
            });
            this.setLocation(frame);
            this.setIcon(frame);
            return frame;
        });
        try {
            SwingUtilities.invokeAndWait(task);
            this._frame = task.get();
        }
        catch (InterruptedException | InvocationTargetException | ExecutionException ex) {
            if (ex instanceof ExecutionException && ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new IllegalStateException(ex);
        }
        this._swingCtx = new SwingInstallerContext(argCtx, this._frame);
        argCtx.setMessageRenderer(new SwingMessageRenderer(argCtx, this._frame));
        argCtx.addBuildListener(new FeedbackListener(this._swingCtx));
    }

    @Override
    public void antFinished() {
        SwingUtilities.invokeLater(() -> {
            this._currentPage.getBackButton().setEnabled(false);
            this._currentPage.getNextButton().setEnabled(false);
            this._currentPage.getCancelButton().setEnabled(false);
            this._currentPage.getFinishButton().setText(ResourceHelper.getResourceString("exit"));
            this._currentPage.getFinishButton().setEnabled(true);
            this._currentPage.getFinishButton().requestFocus();
            this._currentPage.getTitleLabel().setText(ResourceHelper.getResourceString("complete"));
            this._ctx.getMessageRenderer().printMessage(ResourceHelper.getResourceString("finished"));
        });
    }

    @Override
    public void awaitUiCompletion() {
        try {
            this._uiCloseLatch.await();
        }
        catch (InterruptedException ex1) {
            this._logger.log("Interrupted while waiting.");
        }
    }

    @Override
    public void fatalError() {
        SwingUtilities.invokeLater(() -> {
            Page[] pages = this._installer.getPages();
            if (pages != null && pages.length > 0) {
                this.renderNext(pages.length - 1);
                this._currentPage.getBackButton().setEnabled(false);
                this._currentPage.getNextButton().setEnabled(false);
                this._currentPage.getCancelButton().setEnabled(false);
                this._currentPage.getFinishButton().setText(ResourceHelper.getResourceString("exit"));
                this._currentPage.getFinishButton().setEnabled(true);
                this._currentPage.getFinishButton().requestFocus();
                this._currentPage.getTitleLabel().setText(ResourceHelper.getResourceString("failed"));
            }
        });
    }

    public JFrame getFrame() {
        return this._frame;
    }

    @Override
    public void pageBack(Page page) {
        if (page.isAbort()) {
            this.abort();
            return;
        }
        if (page.isExit()) {
            this.exit();
            return;
        }
        Page[] pages = this._installer.getPages();
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i] != page || i <= 0) continue;
            int nextIdx = i - 1;
            try {
                while (!this._ifHelper.ifTarget(pages[nextIdx], pages) || !this._ifHelper.ifProperty(pages[nextIdx])) {
                    --nextIdx;
                }
            }
            catch (InstallException instExc) {
                this._logger.log("InstallException rendering page:" + page.getName());
                this._logger.log(this._installer, (Throwable)instExc);
            }
            this.renderNext(nextIdx);
            return;
        }
    }

    @Override
    public void pageComplete(Page page) {
        block10: {
            try {
                if (page.isAbort()) {
                    this.abort();
                    return;
                }
                if (page.isExit()) {
                    this.exit();
                    return;
                }
                this.runPost(page);
                Page[] pages = this._installer.getPages();
                for (int i = 0; i < pages.length; ++i) {
                    if (pages[i] != page) continue;
                    boolean validationPassed = false;
                    try {
                        this._currentPage.updateInputFields();
                        validationPassed = this._currentPage.validateFields();
                    }
                    catch (ValidationException ve) {
                        this._logger.log("ValidationException rendering page:" + page.getName());
                        this._logger.log(this._installer, (Throwable)ve);
                        return;
                    }
                    if (!validationPassed) {
                        return;
                    }
                    if (i < pages.length - 1) {
                        int nextIdx = i + 1;
                        while (!this._ifHelper.ifTarget(pages[nextIdx], pages) || !this._ifHelper.ifProperty(pages[nextIdx])) {
                            ++nextIdx;
                        }
                        this.renderNext(nextIdx);
                        return;
                    }
                    if (i != pages.length - 1) continue;
                    this._currentPage.getBackButton().setEnabled(false);
                    this._currentPage.getNextButton().setEnabled(false);
                    this._currentPage.getFinishButton().setEnabled(false);
                    this._doAnt.set(true);
                    this._uiCompleteLatch.countDown();
                    return;
                }
            }
            catch (Throwable e) {
                this._ctx.log("Throwable during page completion:" + e.getMessage());
                if (!this._ctx.getInstaller().isVerbose()) break block10;
                this._ctx.log(e);
            }
        }
    }

    @Override
    public boolean runInstaller() throws InstallException {
        try {
            SwingUtilities.invokeAndWait(() -> this.showFirstPage());
            try {
                this._uiCompleteLatch.await();
            }
            catch (InterruptedException ex1) {
                this._logger.log("Interrupted while waiting.");
            }
            return this._doAnt.get();
        }
        catch (Exception ex) {
            this._logger.log("Fatal exception: " + ex.getMessage());
            if (this._ctx.getInstaller().isVerbose()) {
                this._logger.log(ex);
            }
            this._ctx.getMessageRenderer().printMessage("Fatal exception: " + ex.getMessage());
            throw new InstallException("", ex);
        }
    }

    public String toString() {
        return "SwingRunner";
    }

    protected void abort() {
        this._doAnt.set(false);
        this._uiCompleteLatch.countDown();
        this._uiCloseLatch.countDown();
    }

    protected void exit() {
        this._uiCloseLatch.countDown();
        SwingUtilities.invokeLater(() -> {
            this._frame.setVisible(false);
            this._frame.dispose();
        });
    }

    protected IfPropertyHelper getIfHelper() {
        return this._ifHelper;
    }

    protected InstallerContext getInstallerContext() {
        return this._ctx;
    }

    protected void renderNext(int argPageNumber) {
        Page page = this.getInstallerContext().getInstaller().getPages()[argPageNumber];
        this._ctx.setCurrentPage(page);
        this._currentPage = this.preparePage(page, argPageNumber);
        this._currentPage.updateDefaultValues();
        this._frame.getContentPane().removeAll();
        this._frame.getContentPane().add(this._currentPage);
        this._frame.revalidate();
        if (!this._frame.isVisible()) {
            this._frame.setVisible(true);
        }
        if (this._currentPage.getNextButton().isEnabled()) {
            this._frame.getRootPane().setDefaultButton(this._currentPage.getNextButton());
            this._currentPage.getNextButton().requestFocusInWindow();
        } else if (this._currentPage.getFinishButton().isEnabled()) {
            this._frame.getRootPane().setDefaultButton(this._currentPage.getFinishButton());
            this._currentPage.getFinishButton().requestFocusInWindow();
        }
    }

    protected void showFirstPage() {
        this.renderNext(0);
    }

    private List<? extends Image> getIcons() {
        ArrayList<Image> results = new ArrayList<Image>();
        String iconResource = this._installer.getWindowIcon();
        StringTokenizer tokenizer = new StringTokenizer(iconResource, "|");
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken();
            Image img = this.loadImage(fileName);
            if (img == null) continue;
            results.add(img);
        }
        return results;
    }

    private Image loadImage(String iconResource) {
        URL iconUrl;
        if (iconResource != null && (iconUrl = this.getClass().getResource(iconResource)) != null) {
            try {
                return ImageIO.read(iconUrl);
            }
            catch (IOException ex) {
                this._logger.log("Couldn't load image " + iconResource, (Throwable)ex);
            }
        }
        return null;
    }

    private AbstractSwingPageRenderer preparePage(Page argPage, int argPageNumber) {
        try {
            AbstractSwingPageRenderer renderer = RendererFactory.getSwingPageRenderer(argPage);
            if (argPageNumber == 0) {
                renderer.getBackButton().setEnabled(false);
            }
            renderer.setContext(this._swingCtx);
            renderer.setPageCompletionListener(this);
            renderer.setPage(argPage);
            renderer.instanceInit();
            if (renderer instanceof AntOutputRenderer) {
                this._ctx.setAntOutputRenderer((AntOutputRenderer)((Object)renderer));
            }
            return renderer;
        }
        catch (IOException | ClassNotFoundException | ConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void setIcon(JFrame argFrame) {
        List<? extends Image> icons = this.getIcons();
        if (!icons.isEmpty()) {
            argFrame.setIconImages(icons);
        }
    }

    private void setLocation(JFrame argFrame) {
        GraphicsConfiguration config = argFrame.getGraphicsConfiguration();
        int x = (int)config.getBounds().getCenterX() - SizeHelper.getPageWidth() / 2;
        int y = (int)config.getBounds().getCenterY() - SizeHelper.getPageHeight() / 2;
        argFrame.setLocation(x, y);
        argFrame.setResizable(false);
    }
}

