/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.runtime.exe.FilterChain;

public class FilterFactory {
    public static final String FILTER_RESOURCE = "/antinstall-config.fconfig";

    /*
     * Enabled aggressive exception aggregation
     */
    public static FilterChain factory(String configResource) throws InstallException {
        try (InputStream is = FilterFactory.class.getResourceAsStream(configResource);){
            DynamicFilterChain dynamicFilterChain;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String filterClass = null;
                ArrayList<ExecuteFilter> filterChain = new ArrayList<ExecuteFilter>();
                while ((filterClass = br.readLine()) != null) {
                    if (filterClass.startsWith("#") || "".equals(filterClass = filterClass.trim())) continue;
                    filterChain.add((ExecuteFilter)Class.forName(filterClass).newInstance());
                }
                dynamicFilterChain = new DynamicFilterChain(configResource, filterChain);
            }
            return dynamicFilterChain;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new InstallException("Can not create FilterChain");
    }

    private FilterFactory() {
    }

    private static class DynamicFilterChain
    implements FilterChain {
        private ExecuteFilter[] _filters;
        private String _configResource;

        DynamicFilterChain(String argConfigResource, List<ExecuteFilter> filterChain) {
            this._configResource = argConfigResource;
            this._filters = new ExecuteFilter[filterChain.size()];
            filterChain.toArray(this._filters);
        }

        @Override
        public ExecuteFilter[] getFilters() {
            return this._filters;
        }

        @Override
        public void init(InstallerContext ctx) {
            ctx.setConfigResource(this._configResource);
        }
    }
}

