/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.Pager;
import org.tp23.antinstaller.runtime.Runner;
import org.tp23.antinstaller.runtime.TextRunner;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.runtime.exe.ReleaseNotesFrame;

public class ReleaseNotesFilter
implements ExecuteFilter {
    private static final String NEXT_CHAR = ResourceHelper.getResourceString("nextChar");
    public static final String RELEASE_NOTES_PROPERTY = "show.release.notes";

    @Override
    public void exec(InstallerContext ctx) throws InstallException {
        String showReleaseNotes;
        if (ctx.isInstallSucceded() && AbstractInputField.isTrue(showReleaseNotes = ctx.getInstaller().getResultContainer().getProperty(RELEASE_NOTES_PROPERTY))) {
            try {
                InputStream is = ReleaseNotesFilter.class.getResourceAsStream("/release-notes.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                String line = null;
                StringBuffer file = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    file.append(line).append('\n');
                }
                br.close();
                Runner runner = ctx.getRunner();
                if (runner instanceof TextRunner) {
                    this.renderText(file.toString());
                } else {
                    ReleaseNotesFrame rFrame = new ReleaseNotesFrame("Readme");
                    rFrame.init(file.toString());
                }
            }
            catch (IOException e) {
                throw new InstallException("Could not render Release notes", e);
            }
        }
    }

    private String getNextInstructions() {
        return ResourceHelper.getResourceString("large.select.next");
    }

    private void renderText(String text) {
        Pager pager;
        Console console = System.console();
        if (console != null) {
            pager = new Pager(text);
            String command = null;
            while (pager.next(console)) {
                command = console.readLine("%n%s%n", this.getNextInstructions());
                if (command.toUpperCase().startsWith(NEXT_CHAR)) continue;
            }
        } else {
            throw new IllegalStateException("No console available!");
        }
        pager.rest(console);
    }
}

