/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.logic;

import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.logic.Expression;
import org.tp23.antinstaller.runtime.logic.LiteralValue;
import org.tp23.antinstaller.runtime.logic.Value;
import org.tp23.antinstaller.runtime.logic.ValuesTest;
import org.tp23.antinstaller.runtime.logic.VariableValue;

public class SimpleExpression
implements Expression {
    private final Value _value1;
    private final ValuesTest _testCondition;
    private final Value _value2;
    private final String _literalValue1;
    private final String _literalValue2;

    public SimpleExpression(ResultContainer resultContainer, String argValue1, ValuesTest test, String argValue2) throws ConfigurationException {
        this._literalValue1 = argValue1;
        this._value1 = this.getValue(resultContainer, argValue1);
        this._testCondition = test;
        this._literalValue2 = argValue2;
        this._value2 = this.getValue(resultContainer, argValue2);
    }

    @Override
    public boolean evaluate() {
        return this._testCondition.getTestResult(this._value1, this._value2);
    }

    public String toString() {
        return "[" + this._literalValue1 + "==" + this._literalValue2 + "]";
    }

    private Value getValue(ResultContainer container, String valueStr) throws ConfigurationException {
        if (valueStr.length() > 0 && valueStr.charAt(0) == '$') {
            if (valueStr.startsWith("${") && valueStr.endsWith("}")) {
                return new VariableValue(container, valueStr);
            }
            throw new ConfigurationException("Badly formed variable: '" + valueStr + "'");
        }
        return new LiteralValue(valueStr);
    }
}

