/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class CountCodeLines
extends Task {
    private static final Pattern NEW_LINE = Pattern.compile("[\r\n]+");
    private static final Pattern EMPTY_LINE = Pattern.compile("^[\\{\\}]*$");
    private static final Pattern SINGLE_LINE_COMMENT = Pattern.compile("(?<=;|^)\\s*\\/\\/.*$", 8);
    private static final Pattern MULTI_LINE_COMMENT = Pattern.compile("\\/\\*.+?\\*\\/", 32);
    private static final Pattern EXECUTABLE = Pattern.compile("(.*\\;$|.*(\\w+|\\)|\\>)\\s*\\{$)");
    private final AtomicBoolean _failureOccurred = new AtomicBoolean(false);
    private final LongAdder _totalActualLines = new LongAdder();
    private final LongAdder _totalExecCount = new LongAdder();
    private final LongAdder _totalLineCount = new LongAdder();
    private final LongAdder _totalFileCount = new LongAdder();
    private List<ResourceCollection> _collections = new ArrayList<ResourceCollection>();
    private long _timeout = 120000L;
    private Path _rootDir;

    public void add(ResourceCollection resourceCollection) {
        this._collections.add(resourceCollection);
    }

    @Override
    public void execute() throws BuildException {
        long l = System.currentTimeMillis();
        ExecutorService executorService = Executors.newWorkStealingPool();
        try {
            this.scan(executorService);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        finally {
            executorService.shutdown();
            try {
                executorService.awaitTermination(this._timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                executorService.shutdownNow();
                throw new BuildException(interruptedException);
            }
        }
        if (this._failureOccurred.get()) {
            throw new BuildException("An error occurred when reading files.");
        }
        long l2 = System.currentTimeMillis() - l;
        long l3 = this._totalActualLines.sum();
        long l4 = this._totalLineCount.sum();
        long l5 = this._totalExecCount.sum();
        long l6 = this._totalFileCount.sum();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-------------------------------Source Code Content Analysis-------------------------------\n");
        stringBuilder.append("a. Actual Line Count: ").append(l3).append("\n");
        stringBuilder.append("b. Effective Line Count(without lone braces, only linefeeds, or comments): ").append(l4).append("\n");
        stringBuilder.append("c. Executable Line Count(with those ending with semicolon or starting a block): ").append(l5).append("\n");
        stringBuilder.append("d. Percentage of Executable Code Coverage (c/a*100): ").append((float)l5 / (float)l3 * 100.0f).append("\n");
        stringBuilder.append("   Files Inspected: ").append(l6).append("\n");
        stringBuilder.append("   Time Taken: ").append(l2).append("ms\n");
        stringBuilder.append("------------------------------------------------------------------------------------------\n");
        this.log(stringBuilder.toString());
    }

    public void setDir(File file) {
        this._rootDir = file.toPath();
    }

    public void setTimeout(long l) {
        this._timeout = l;
    }

    private void readContent(FileByteProvider fileByteProvider, ExecutorService executorService) {
        executorService.submit(new LineCountWorker(fileByteProvider, this._failureOccurred, this._totalActualLines, this._totalExecCount, this._totalLineCount, this._totalFileCount, this.getProject()));
    }

    private void readFile(Path path, ExecutorService executorService) throws IOException {
        PathFileByteProvider pathFileByteProvider = new PathFileByteProvider(path);
        this.readContent(pathFileByteProvider, executorService);
    }

    private void readResource(Resource resource, ExecutorService executorService) throws IOException {
        if (resource instanceof FileResource) {
            FileResource fileResource = (FileResource)resource;
            File file = fileResource.getFile();
            this.readFile(file.toPath(), executorService);
        } else {
            ResourceByteProvider resourceByteProvider = new ResourceByteProvider(resource);
            this.readContent(resourceByteProvider, executorService);
        }
    }

    private void scan(ExecutorService executorService) throws IOException {
        if (this._rootDir != null) {
            this.scanDirectory(executorService);
        } else if (!this._collections.isEmpty()) {
            this.scanResources(executorService);
        }
    }

    private void scanDirectory(final ExecutorService executorService) throws IOException {
        Files.walkFileTree(this._rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (path.getFileName().toString().endsWith(".java")) {
                    CountCodeLines.this.readFile(path, executorService);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void scanResources(ExecutorService executorService) throws IOException {
        for (ResourceCollection resourceCollection : this._collections) {
            for (Resource resource : resourceCollection) {
                if (resource.isDirectory() || !resource.getName().endsWith(".java")) continue;
                this.readResource(resource, executorService);
            }
        }
    }

    private static class ResourceByteProvider
    implements FileByteProvider {
        private final Resource _resource;

        private ResourceByteProvider(Resource resource) {
            this._resource = resource;
        }

        @Override
        public byte[] getBytes() throws IOException {
            byte[] byArray = new byte[(int)this._resource.getSize()];
            try (InputStream inputStream = this._resource.getInputStream();){
                if ((long)inputStream.read(byArray) != this._resource.getSize()) {
                    throw new IOException("Could not read all bytes of resource " + this._resource.getName());
                }
            }
            return byArray;
        }

        @Override
        public String getName() {
            return this._resource.getName();
        }
    }

    private static class PathFileByteProvider
    implements FileByteProvider {
        private final Path _path;

        private PathFileByteProvider(Path path) {
            this._path = path;
        }

        @Override
        public byte[] getBytes() throws IOException {
            return Files.readAllBytes(this._path);
        }

        @Override
        public String getName() {
            return this._path.getFileName().toString();
        }
    }

    private static class LineCountWorker
    implements Runnable {
        private final FileByteProvider _provider;
        private final AtomicBoolean _failure;
        private final LongAdder _actualLines;
        private final LongAdder _execCount;
        private final LongAdder _lineCount;
        private final LongAdder _fileCount;
        private final Project _project;
        private final Matcher _empty;
        private final Matcher _exec;

        private LineCountWorker(FileByteProvider fileByteProvider, AtomicBoolean atomicBoolean, LongAdder longAdder, LongAdder longAdder2, LongAdder longAdder3, LongAdder longAdder4, Project project) {
            this._provider = fileByteProvider;
            this._failure = atomicBoolean;
            this._actualLines = longAdder;
            this._execCount = longAdder2;
            this._lineCount = longAdder3;
            this._fileCount = longAdder4;
            this._project = project;
            this._empty = EMPTY_LINE.matcher("");
            this._exec = EXECUTABLE.matcher("");
        }

        @Override
        public void run() {
            try {
                byte[] byArray = this._provider.getBytes();
                this._fileCount.increment();
                String string = new String(byArray, StandardCharsets.UTF_8);
                this.countActualLines(string);
                string = MULTI_LINE_COMMENT.matcher(string).replaceAll("");
                string = SINGLE_LINE_COMMENT.matcher(string).replaceAll("");
                this.evaluateLines(string);
            }
            catch (IOException iOException) {
                this._failure.compareAndSet(false, true);
                this._project.log("An error occurred when reading: " + this._provider.getName(), iOException, 1);
            }
        }

        private void countActualLines(String string) {
            int n = 1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\n') continue;
                ++n;
            }
            this._actualLines.add(n);
        }

        private void evaluateLine(String string) {
            String string2 = string.trim();
            if (this._empty.reset(string2).matches()) {
                return;
            }
            if (this._exec.reset(string2).matches()) {
                this._execCount.increment();
            }
            this._lineCount.increment();
        }

        private void evaluateLines(String string) {
            String string2;
            Matcher matcher = NEW_LINE.matcher(string);
            int n = 0;
            while (matcher.find()) {
                if (n == 0 && n == matcher.start() && matcher.start() == matcher.end()) continue;
                string2 = string.substring(n, matcher.start());
                this.evaluateLine(string2);
                n = matcher.end();
            }
            string2 = string.substring(n, string.length());
            this.evaluateLine(string2);
        }
    }

    private static interface FileByteProvider {
        public byte[] getBytes() throws IOException;

        public String getName();
    }
}

