/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DeleteFile
extends Task {
    private Boolean gcBeforeDelete_ = true;
    private File deleteFile_;
    private int retryDelayMills_ = 15;
    private int numberOfRetries_ = 2;

    @Override
    public void execute() throws BuildException {
        if (this.deleteFile_.isDirectory()) {
            throw new BuildException("This task only supports deleting a single file.");
        }
        if (!this.deleteFile_.exists()) {
            this.log("File [" + this.deleteFile_.getAbsolutePath() + "] does not appear to exist and will not be deleted.");
            return;
        }
        this.log("Deleting " + this.deleteFile_.getAbsolutePath());
        boolean bl = this.delete(false);
        int n = 0;
        while (!bl) {
            ++n;
            this.log("Delete attempt failed.  Waiting " + this.retryDelayMills_ + " milliseconds.");
            try {
                Thread.sleep(this.retryDelayMills_);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = this.delete(n >= this.numberOfRetries_);
        }
    }

    public void setFile(File file) {
        this.deleteFile_ = file;
    }

    public void setGc(Boolean bl) {
        this.gcBeforeDelete_ = bl;
    }

    public void setNumRetries(int n) {
        this.numberOfRetries_ = n;
    }

    public void setRetryDelay(int n) {
        this.retryDelayMills_ = n;
    }

    private boolean delete(boolean bl) {
        boolean bl2;
        block5: {
            if (this.gcBeforeDelete_.booleanValue()) {
                System.gc();
            }
            if (!(bl2 = this.deleteFile_.delete())) {
                try {
                    Path path = this.deleteFile_.toPath();
                    Files.delete(path);
                    bl2 = true;
                }
                catch (IOException iOException) {
                    if (!bl) break block5;
                    if (this.isWindows()) {
                        this.nativeWindowsDelete();
                        bl2 = true;
                    }
                    throw new BuildException("Could not delete file because of: " + iOException.getMessage());
                }
            }
        }
        return bl2;
    }

    private boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("win");
    }

    private void nativeWindowsDelete() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", "del /f /q " + this.deleteFile_.getAbsolutePath());
            Process process = processBuilder.start();
            if (process.waitFor() != 0) {
                throw new Exception("An error occurred when attempting to delete the file.");
            }
        }
        catch (Exception exception) {
            this.log("An attempt to perform a native delete failed because of: " + exception.getMessage());
        }
        if (this.deleteFile_.exists()) {
            throw new BuildException("The file could not be deleted.");
        }
    }
}

