/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import com.micros_retail.ant.compile.DuplicateMode;
import com.micros_retail.ant.compile.JarCompileHelper;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceCollection;

public class JavacToJar
extends Task {
    private List<Manifest> _manifest = new ArrayList<Manifest>();
    private List<SourceDir> _sourceDirs = new ArrayList<SourceDir>();
    private List<CompilerArg> _compilerArgs = new ArrayList<CompilerArg>();
    private List<ResourceCollection> _additionalFiles = new ArrayList<ResourceCollection>();
    private boolean _includeAntRuntime = true;
    private boolean _includeJavaRuntime = true;
    private DuplicateMode _duplicateMode = DuplicateMode.WARN;
    private Path _compileClasspath = null;
    private java.nio.file.Path _destFile = null;
    private Charset _encoding = StandardCharsets.UTF_8;

    public void add(ResourceCollection resourceCollection) {
        this._additionalFiles.add(resourceCollection);
    }

    public Path createClasspath() {
        if (this._compileClasspath == null) {
            this._compileClasspath = new Path(this.getProject());
        }
        return this._compileClasspath.createPath();
    }

    public CompilerArg createCompilerArg() {
        CompilerArg compilerArg = new CompilerArg();
        this._compilerArgs.add(compilerArg);
        return compilerArg;
    }

    public Manifest createManifest() {
        Manifest manifest = new Manifest();
        this._manifest.add(manifest);
        return manifest;
    }

    public SourceDir createSourceDir() {
        SourceDir sourceDir = new SourceDir();
        this._sourceDirs.add(sourceDir);
        return sourceDir;
    }

    @Override
    public void execute() throws BuildException {
        if (this._destFile == null) {
            throw new BuildException("destfile must be specified");
        }
        List<java.nio.file.Path> list = this._sourceDirs.stream().map(sourceDir -> sourceDir._dir.toPath()).collect(Collectors.toList());
        Map<String, String> map = this._manifest.stream().flatMap(manifest -> manifest._attributes.stream()).collect(Collectors.toMap(attribute -> attribute._name, attribute -> attribute._value));
        List<String> list2 = this._compilerArgs.stream().map(compilerArg -> compilerArg._arg).collect(Collectors.toList());
        Path path = new Path(this.getProject());
        Path path2 = this._compileClasspath;
        if (path2 == null) {
            this.log("Proceeding with compilation with the default classpath.", 1);
            path2 = path;
        }
        if (this._includeAntRuntime) {
            path2.addExisting(path.concatSystemClasspath("last"));
        } else {
            path2.addExisting(path.concatSystemClasspath("ignore"));
        }
        if (this._includeJavaRuntime) {
            path2.addJavaRuntime();
        }
        list2.add("-classpath");
        list2.add(path2.toString());
        java.nio.file.Path path3 = this._destFile.getParent();
        if (Files.notExists(path3, new LinkOption[0])) {
            try {
                this.log("Creating: " + path3);
                Files.createDirectories(path3, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        }
        try {
            long l = System.currentTimeMillis();
            int n = JarCompileHelper.compile(list, this._additionalFiles, this._destFile, map, list2, this._encoding, this._duplicateMode);
            long l2 = System.currentTimeMillis();
            this.log("Processed [" + n + "] files into " + this._destFile + " in " + (l2 - l) + "ms");
        }
        catch (IOException | URISyntaxException exception) {
            throw new BuildException(exception);
        }
    }

    public Path getClasspath() {
        return this._compileClasspath;
    }

    public void setClasspath(Path path) {
        if (this._compileClasspath == null) {
            this._compileClasspath = path;
        } else {
            this._compileClasspath.append(path);
        }
    }

    public void setDestFile(File file) {
        this._destFile = file.toPath();
    }

    public void setDuplicateMode(String string) {
        this._duplicateMode = DuplicateMode.valueOf(string.toUpperCase());
    }

    public void setEncoding(String string) {
        this._encoding = Charset.forName(string);
    }

    public void setIncludeAntRuntime(boolean bl) {
        this._includeAntRuntime = bl;
    }

    public void setIncludeJavaRuntime(boolean bl) {
        this._includeJavaRuntime = bl;
    }

    public static class SourceDir {
        File _dir;

        public void setDir(File file) {
            this._dir = file;
        }
    }

    public static class Manifest {
        final List<Attribute> _attributes = new ArrayList<Attribute>();

        public Attribute createAttribute() {
            Attribute attribute = new Attribute();
            this._attributes.add(attribute);
            return attribute;
        }
    }

    public static class CompilerArg {
        String _arg;

        public void setArg(String string) {
            this._arg = string;
        }
    }

    public static class Attribute {
        String _name;
        String _value;

        public void setName(String string) {
            this._name = string;
        }

        public void setValue(String string) {
            this._value = string;
        }
    }
}

