/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.IOException;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ResourceDecorator;
import org.apache.tools.tar.TarOutputStream;

public class TarWithDateOverride
extends Tar {
    private final long _overrideTime = System.currentTimeMillis();
    private boolean _overrideTimestamp = false;

    public void setOverrideTimestamp(Boolean bl) {
        this._overrideTimestamp = bl;
    }

    @Override
    protected void tarResource(Resource resource, TarOutputStream tarOutputStream, String string, Tar.TarFileSet tarFileSet) throws IOException {
        if (this._overrideTimestamp) {
            super.tarResource(new TimeOverrideDecorator(resource, this._overrideTime), tarOutputStream, string, tarFileSet);
        } else {
            super.tarResource(resource, tarOutputStream, string, tarFileSet);
        }
    }

    private static class TimeOverrideDecorator
    extends ResourceDecorator {
        private final long _lastModified;

        private TimeOverrideDecorator(Resource resource, long l) {
            super(resource);
            this._lastModified = l;
        }

        @Override
        public long getLastModified() {
            return this._lastModified;
        }
    }
}

