/*
 * Decompiled with CFR 0.152.
 */
package oracle.retail.xstore.installer.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;
import oracle.retail.xstore.installer.resource.IFileResource;
import oracle.retail.xstore.installer.resource.IResource;
import oracle.retail.xstore.installer.resource.IResourceContainer;
import oracle.retail.xstore.installer.resource.impl.Resource;

public class DirectoryResourceContainer
implements IResourceContainer {
    private final Path _directory;
    private final Stream<Path> _stream;

    public DirectoryResourceContainer(File argDirectory) throws IOException {
        if (!argDirectory.isDirectory()) {
            throw new IllegalArgumentException("Only directories are supported.");
        }
        this._directory = argDirectory.toPath();
        this._stream = Files.walk(this._directory, new FileVisitOption[0]);
    }

    @Override
    public void close() throws IOException {
        this._stream.close();
    }

    @Override
    public File getRoot() {
        return this._directory.toFile();
    }

    @Override
    public Iterator<IResource> iterator() {
        return new DirectoryResourceIterator(this._directory, this._stream);
    }

    private static class PathResource
    extends Resource
    implements IFileResource {
        private final Path _file;

        public PathResource(String argPath, String argName, Path argFile) {
            super(argPath, argName);
            this._file = argFile;
        }

        @Override
        public InputStream getInput() throws IOException {
            return Files.newInputStream(this._file, new OpenOption[0]);
        }
    }

    private static class DirectoryResourceIterator
    implements Iterator<IResource> {
        private final Path _directory;
        private final Iterator<Path> _pathIterator;

        private static String getRelativePath(Path argContainer, Path argChild) {
            Path relativePath = argContainer.relativize(argChild);
            StringBuilder normalizedPath = new StringBuilder();
            for (int i = 0; i < relativePath.getNameCount(); ++i) {
                if (normalizedPath.length() > 0) {
                    normalizedPath.append('/');
                }
                normalizedPath.append(relativePath.getName(i).toString());
            }
            return normalizedPath.toString();
        }

        DirectoryResourceIterator(Path argFile, Stream<Path> stream) {
            this._directory = argFile;
            this._pathIterator = stream.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._pathIterator.hasNext();
        }

        @Override
        public IResource next() {
            Path current = this._pathIterator.next();
            String path = DirectoryResourceIterator.getRelativePath(this._directory, current);
            String name = current.getFileName().toString();
            if (Files.isDirectory(current, new LinkOption[0])) {
                return new Resource(path, name);
            }
            return new PathResource(path, name, current);
        }
    }
}

