/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.ResultContainer;

public abstract class AbstractInputField {
    private static final ResourceBundle LANG_PACK;
    private String _property;
    protected String _defaultValue;
    private boolean _editted = false;
    protected String _displayText;
    protected String _explanatoryText;
    protected ResultContainer _resultContainer;

    public static boolean isFalse(String value) {
        if (value == null) {
            return false;
        }
        return "false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value);
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static boolean optionalBoolean(String value) {
        return value == null || AbstractInputField.isTrue(value) || AbstractInputField.isFalse(value);
    }

    public static boolean requiredBoolean(String value) {
        return AbstractInputField.isTrue(value) || AbstractInputField.isFalse(value);
    }

    public String getDefaultValue() {
        if (this.isEditted()) {
            return this.getInputResult();
        }
        return this._resultContainer.getDefaultValue(this._defaultValue);
    }

    public String getDisplayText() {
        return this.getTranslatedOrDefault(this.getProperty() + ".displayText", this._displayText);
    }

    public String getExplanatoryText() {
        return this.getTranslatedOrDefault(this.getProperty() + ".explanatoryText", this._explanatoryText);
    }

    public String getInputResult() {
        return this._resultContainer.getProperty(this._property);
    }

    public String getProperty() {
        return this._property;
    }

    public boolean isEditted() {
        return this._editted;
    }

    public void setDefaultValue(String argDefaultValue) {
        this._defaultValue = argDefaultValue;
    }

    public void setDisplayText(String argDisplayText) {
        this._displayText = argDisplayText;
    }

    public void setEditted(boolean argEditted) {
        this._editted = argEditted;
    }

    public void setExplanatoryText(String argExplanatoryText) {
        this._explanatoryText = argExplanatoryText;
    }

    public void setInputResult(String inputResult) {
        this._resultContainer.setProperty(this._property, inputResult);
    }

    public void setProperty(String argProperty) {
        this._property = argProperty;
    }

    public void setResultContainer(ResultContainer argResultContainer) {
        this._resultContainer = argResultContainer;
    }

    public abstract boolean validate(InstallerContext var1) throws ValidationException;

    public abstract boolean validateObject(Consumer<String> var1);

    protected String getTranslatedOrDefault(String argKey, String argDefault) {
        if (LANG_PACK != null && LANG_PACK.containsKey(argKey)) {
            return LANG_PACK.getString(argKey);
        }
        return argDefault;
    }

    static {
        ResourceBundle langPack = null;
        try {
            langPack = ResourceBundle.getBundle("resources.LanguagePack");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        LANG_PACK = langPack;
    }
}

