/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;

public class AppRootInput
extends DirectoryInput {
    private String _checkFile1;
    private String _checkFile2;
    private String _checkDir1;
    private String _checkDir2;

    public String getCheckDir1() {
        return this._checkDir1;
    }

    public String getCheckDir2() {
        return this._checkDir2;
    }

    public String getCheckFile1() {
        return this._checkFile1;
    }

    public String getCheckFile2() {
        return this._checkFile2;
    }

    public void setCheckDir1(String argCheckDir1) {
        this._checkDir1 = argCheckDir1;
    }

    public void setCheckDir2(String argCheckDir2) {
        this._checkDir2 = argCheckDir2;
    }

    public void setCheckFile1(String argCheckFile1) {
        this._checkFile1 = argCheckFile1;
    }

    public void setCheckFile2(String argCheckFile2) {
        this._checkFile2 = argCheckFile2;
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        MessageRenderer mr = cxt.getMessageRenderer();
        String directorySelected = this.getInputResult();
        File file = new File(directorySelected);
        if (!file.isDirectory()) {
            mr.printMessage(ResourceHelper.getResourceString("dirNotExist") + ":" + file.getAbsolutePath());
            return false;
        }
        if (this._checkFile1 != null && !this.checkExists(mr, file, this._checkFile1)) {
            return false;
        }
        if (this._checkFile2 != null && !this.checkExists(mr, file, this._checkFile2)) {
            return false;
        }
        if (this._checkDir1 != null && !this.checkExists(mr, file, this._checkDir1)) {
            return false;
        }
        return this._checkDir2 == null || this.checkExists(mr, file, this._checkDir2);
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("AppRoot:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("AppRoot:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("AppRoot:defaultValue must be set");
            return false;
        }
        return true;
    }

    private boolean checkExists(MessageRenderer mr, File root, String check) {
        File checkFile = new File(root, check);
        if (!checkFile.exists()) {
            this.reportMissing(mr, checkFile);
            return false;
        }
        return true;
    }

    private void reportMissing(MessageRenderer mr, File missing) {
        StringBuffer message = new StringBuffer();
        message.append(ResourceHelper.getResourceString("appRootInvalid"));
        message.append(System.getProperty("line.separator"));
        if (missing.isDirectory()) {
            message.append(ResourceHelper.getResourceString("dirNotExist"));
        } else {
            message.append(ResourceHelper.getResourceString("fileNotExist"));
        }
        message.append(":");
        message.append(missing.getAbsolutePath());
        mr.printMessage(message.toString());
    }
}

