/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.function.Consumer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;

public class EvaluatedPropertyInput
extends AbstractInputField {
    private static final String TYPE_NAME = "evaluate";
    private final InstallerContext _context;
    private String _expression;

    public EvaluatedPropertyInput(InstallerContext argCtx) {
        this._context = argCtx;
    }

    @Override
    public String getDefaultValue() {
        try {
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine engine = mgr.getEngineByName("JavaScript");
            engine.put("container", this._context.getInstaller().getResultContainer());
            Object result = engine.eval(this._expression);
            if (result == null) {
                result = engine.get("result");
            }
            if (result != null) {
                return String.valueOf(result);
            }
            this._context.log("Evaluation of expression '" + this._expression + "' did not produce a value.");
        }
        catch (Exception ex) {
            this._context.log("Couldn't evaluate expression '" + this._expression + "' " + ex.getMessage());
        }
        return "";
    }

    public void setExpression(String argExpression) {
        this._expression = argExpression;
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        return true;
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getProperty() == null) {
            argOutputHandler.accept("evaluate: property must be set");
            return false;
        }
        if (this._expression == null) {
            argOutputHandler.accept("evaluate: expression must be set");
            return false;
        }
        return true;
    }
}

