/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.SizeHelper;

public class CommentOutputRenderer
extends AbstractSwingOutputFieldRenderer {
    private static final Font BOLD_COMMENT_FONT;
    private static final Font TITLE_COMMENT_FONT;
    private JTextComponent _explanatoryTextField;
    private CommentOutput _outputField;

    public JTextComponent getExplanatoryTextField() {
        return this._explanatoryTextField;
    }

    @Override
    public JComponent initComponent(boolean argOverflow) {
        this._fieldLabel.setText(this._outputField.getDisplayText());
        if (this._explanatoryTextField != null) {
            this._explanatoryTextField.setText(this._outputField.getExplanatoryText());
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        int targetWidth = SizeHelper.getPageContentWidth(argOverflow);
        this._fieldLabel.layoutToWidth(targetWidth);
        this.initDimensions(panel, this._fieldLabel, argOverflow);
        panel.add(this._fieldLabel);
        if (AbstractInputField.isTrue(this._outputField.getBold())) {
            this._fieldLabel.setFont(BOLD_COMMENT_FONT);
        }
        if (AbstractInputField.isTrue(this._outputField.getTitle())) {
            this._fieldLabel.setFont(TITLE_COMMENT_FONT);
        }
        return panel;
    }

    public void setExplanatoryTextField(JTextComponent argExplanatoryTextField) {
        this._explanatoryTextField = argExplanatoryTextField;
    }

    @Override
    public void setOutputField(AbstractInputField argOutputField) {
        this._outputField = (CommentOutput)argOutputField;
    }

    @Override
    public void updateDefaultValue() {
    }

    static {
        Font titleCommentFont;
        Font boldCommentFont = new JLabel().getFont();
        try {
            boldCommentFont = new Font(boldCommentFont.getFamily(), 1, boldCommentFont.getSize());
            titleCommentFont = new Font(boldCommentFont.getFamily(), 1, 16);
        }
        catch (Exception ex) {
            titleCommentFont = boldCommentFont;
        }
        BOLD_COMMENT_FONT = boldCommentFont;
        TITLE_COMMENT_FONT = titleCommentFont;
    }
}

