/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.SizeHelper;

public class FileInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private FileInput _inputField;
    private final JTextField _jTextField = new JTextField();
    private final JButton _browseButton = new JButton();
    private final JPanel _browsePanel = new JPanel();
    private final Color _origFore = this._jTextField.getForeground();

    @Override
    public JComponent initComponent(boolean argOverflow) {
        this._browsePanel.setLayout(new BorderLayout());
        this._browsePanel.add((Component)this._jTextField, "Center");
        this._browsePanel.add((Component)this._browseButton, "East");
        this._browseButton.setPreferredSize(new Dimension(90, SizeHelper.getFieldHeight()));
        JPanel panel = this.initDefaultPanel(this._inputField.getDisplayText(), this._browsePanel, argOverflow);
        this._browseButton.addActionListener(e -> {
            int returnVal;
            File selectedFile = null;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileHidingEnabled(false);
            chooser.setFileSelectionMode(0);
            if (this._jTextField.getText() != null) {
                chooser.setCurrentDirectory(new File(this._jTextField.getText()).getParentFile());
            }
            if ((returnVal = chooser.showDialog(panel.getParent(), e.getActionCommand())) == 0) {
                selectedFile = chooser.getSelectedFile();
            }
            if (selectedFile != null) {
                this._jTextField.setText(selectedFile.getAbsolutePath());
                this._inputField.setValue(selectedFile.getAbsolutePath());
                this._inputField.setEditted(true);
            }
        });
        this._browseButton.setText(ResourceHelper.getResourceString("selectFile"));
        this._jTextField.setText(this._inputField.getDefaultValue(true));
        this._jTextField.addActionListener(e -> this.updateInputField());
        this._jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent fe) {
                FileInputRenderer.this.restoreForegroundColor();
            }
        });
        return panel;
    }

    @Override
    public void renderError() {
        MessageRenderer mr = this.getInstallerContext().getMessageRenderer();
        mr.printMessage(ResourceHelper.getResourceString("fileNotExist"));
        this._jTextField.requestFocus();
        this._jTextField.setForeground(Color.red);
    }

    @Override
    public void setOutputField(AbstractInputField argInputField) {
        this._inputField = (FileInput)argInputField;
        this._inputField.setValue(this._inputField.getDefaultValue(true));
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            this._jTextField.setText(this._inputField.getDefaultValue(true));
        }
    }

    @Override
    public void updateInputField() {
        if (!this._inputField.getDefaultValue(true).equals(this._jTextField.getText())) {
            this._inputField.setEditted(true);
        }
        this._inputField.setValue(this._jTextField.getText());
    }

    protected void restoreForegroundColor() {
        this._jTextField.setForeground(this._origFore);
    }
}

