/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.AbstractSwingPageRenderer;
import org.tp23.antinstaller.renderer.swing.DisplayTextArea;
import org.tp23.antinstaller.renderer.swing.SizeHelper;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class SimpleInputPageRenderer
extends AbstractSwingPageRenderer {
    private static final long serialVersionUID = 1L;
    private JScrollPane _scroller = null;
    private final List<AbstractSwingOutputFieldRenderer> _renderers = new ArrayList<AbstractSwingOutputFieldRenderer>();

    @Override
    public void instanceInit() throws IOException, ConfigurationException, ClassNotFoundException {
        boolean overflow = ((SimpleInputPage)this.getPage()).isOverflow();
        JPanel contentPanel = new JPanel();
        SpringLayout layout = new SpringLayout();
        contentPanel.setLayout(layout);
        if (overflow) {
            contentPanel.setMaximumSize(new Dimension(SizeHelper.getPageWidth() - 50, SizeHelper.getPageHeight()));
            this._scroller = new JScrollPane();
            this._scroller.setHorizontalScrollBarPolicy(30);
            this._scroller.setVerticalScrollBarPolicy(20);
            this._scroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
            this.add((Component)this._scroller, "Center");
            this._scroller.getViewport().add(contentPanel);
        } else {
            this.add((Component)contentPanel, "Center");
            contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 10, 4, 10));
        }
        List<AbstractInputField> fields = this.getPage().getOutputFields();
        ArrayList<Component> components = new ArrayList<Component>();
        for (AbstractInputField field : fields) {
            AbstractSwingOutputFieldRenderer renderer = RendererFactory.getSwingRenderer(field);
            String text = field.getExplanatoryText();
            if (field.getExplanatoryText() != null) {
                DisplayTextArea area = new DisplayTextArea();
                area.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
                area.setText(text);
                components.add(contentPanel.add(area));
            }
            renderer.setOutputField(field);
            renderer.setInstallerContext(this.getCtx());
            JComponent component = renderer.initComponent(overflow);
            if (component != null) {
                components.add(contentPanel.add(component));
            }
            this._renderers.add(renderer);
        }
        Component top = contentPanel;
        for (int i = 0; i < components.size(); ++i) {
            String alignTo = i == 0 ? "North" : "South";
            Component component = (Component)components.get(i);
            layout.putConstraint("North", component, 0, alignTo, top);
            layout.putConstraint("West", component, 0, "West", (Component)contentPanel);
            layout.putConstraint("East", component, 0, "East", (Component)contentPanel);
            top = component;
        }
    }

    @Override
    public void updateDefaultValues() {
        for (int i = 0; i < this._renderers.size(); ++i) {
            this._renderers.get(i).updateDefaultValue();
        }
    }

    @Override
    public void updateInputFields() {
        for (int i = 0; i < this._renderers.size(); ++i) {
            this._renderers.get(i).updateInputField();
        }
    }

    @Override
    public boolean validateFields() throws ValidationException {
        List<AbstractInputField> fields = this.getPage().getOutputFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).validate(this.getCtx())) continue;
            AbstractSwingOutputFieldRenderer renderer = this._renderers.get(i);
            renderer.renderError();
            return false;
        }
        return true;
    }
}

